/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.server;

import java.util.ArrayList;
import java.util.List;
import org.apache.chemistry.opencmis.commons.data.Acl;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.enums.IncludeRelationships;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConstraintException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNotSupportedException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUpdateConflictException;
import org.apache.chemistry.opencmis.commons.impl.server.ObjectInfoImpl;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.commons.server.ObjectInfoHandler;
import org.apache.chemistry.opencmis.commons.spi.Holder;
import org.apache.chemistry.opencmis.inmemory.FilterParser;
import org.apache.chemistry.opencmis.inmemory.NameValidator;
import org.apache.chemistry.opencmis.inmemory.TypeValidator;
import org.apache.chemistry.opencmis.inmemory.server.InMemoryAbstractServiceImpl;
import org.apache.chemistry.opencmis.inmemory.server.InMemoryObjectServiceImpl;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Content;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.Document;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.DocumentVersion;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.ObjectStore;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoreManager;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoredObject;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.VersionedDocument;
import org.apache.chemistry.opencmis.inmemory.types.PropertyCreationHelper;
import org.apache.chemistry.opencmis.server.support.TypeManager;

public class InMemoryVersioningServiceImpl
extends InMemoryAbstractServiceImpl {
    private InMemoryObjectServiceImpl fObjectService;

    public InMemoryVersioningServiceImpl(StoreManager storeManager, InMemoryObjectServiceImpl objectService) {
        super(storeManager);
        this.fObjectService = objectService;
    }

    public void cancelCheckOut(CallContext context, String repositoryId, String objectId, ExtensionsData extension) {
        StoredObject so = this.validator.cancelCheckOut(context, repositoryId, objectId, extension);
        ObjectStore objStore = this.fStoreManager.getObjectStore(repositoryId);
        String user = context.getUsername();
        VersionedDocument verDoc = this.testHasProperCheckedOutStatus(so, user);
        DocumentVersion pwc = verDoc.getPwc();
        verDoc.cancelCheckOut(user);
        objStore.deleteVersion(pwc);
        if (verDoc.getAllVersions().size() == 0) {
            this.fStoreManager.getObjectStore(repositoryId).deleteObject(verDoc.getId(), true, user);
        }
    }

    public void checkIn(CallContext context, String repositoryId, Holder<String> objectId, Boolean majorParam, Properties properties, ContentStream contentStreamParam, String checkinComment, List<String> policies, Acl addAces, Acl removeAces, ExtensionsData extension, ObjectInfoHandler objectInfos) {
        PropertyData pd;
        String user;
        Acl aclRemove;
        Acl aclAdd = TypeValidator.expandAclMakros(context.getUsername(), addAces);
        StoredObject so = this.validator.checkIn(context, repositoryId, objectId, aclAdd, aclRemove = TypeValidator.expandAclMakros(context.getUsername(), removeAces), policies, extension);
        VersionedDocument verDoc = this.testHasProperCheckedOutStatus(so, user = context.getUsername());
        DocumentVersion pwc = verDoc.getPwc();
        if (pwc == null || !pwc.getId().equals(objectId.getValue())) {
            throw new CmisConstraintException("Error: Can't checkin, " + objectId + " is not a private working copy.");
        }
        ObjectStore objStore = this.fStoreManager.getObjectStore(repositoryId);
        ContentStream contentStream = contentStreamParam;
        if (contentStream != null) {
            if (contentStream.getStream() == null) {
                contentStream = null;
            } else {
                objStore.setContent(so, contentStream);
            }
        }
        boolean major = null == majorParam ? true : majorParam;
        verDoc.checkIn(major, properties, ((Content)((Object)so)).getContent(), checkinComment, policies, user);
        if (null != properties && null != properties.getProperties() && (pd = (PropertyData)properties.getProperties().get("cmis:name")) != null) {
            String newName = (String)pd.getFirstValue();
            if (newName == null || newName.equals("")) {
                throw new CmisConstraintException("updateProperties failed, name must not be empty.");
            }
            if (!NameValidator.isValidName(newName)) {
                throw new CmisInvalidArgumentException("Name contains illegal characters, not allowed are '/', '\\', ':', '\"', '*'. '?', '<','>', '|'");
            }
            objStore.rename(so, (String)pd.getFirstValue(), user);
        }
        so.updateSystemBasePropertiesWhenModified(null, context.getUsername());
        if (context.isObjectInfoRequired()) {
            ObjectInfoImpl objectInfo = new ObjectInfoImpl();
            this.fAtomLinkProvider.fillInformationForAtomLinks(context, repositoryId, so, objectInfo);
            objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        }
    }

    public void checkOut(CallContext context, String repositoryId, Holder<String> objectId, ExtensionsData extension, Holder<Boolean> contentCopied, ObjectInfoHandler objectInfos) {
        boolean cmis11;
        StoredObject so = this.validator.checkOut(context, repositoryId, objectId, extension, contentCopied);
        TypeDefinition typeDef = this.getTypeDefinition(repositoryId, so, cmis11 = context.getCmisVersion() != CmisVersion.CMIS_1_0);
        if (!typeDef.getBaseTypeId().equals((Object)BaseTypeId.CMIS_DOCUMENT)) {
            throw new CmisNotSupportedException("Only documents can be checked-out.");
        }
        if (!((DocumentTypeDefinition)typeDef).isVersionable().booleanValue()) {
            throw new CmisNotSupportedException("Object can't be checked-out, type is not versionable.");
        }
        this.checkIsVersionableObject(so);
        ObjectStore objectStore = this.fStoreManager.getObjectStore(repositoryId);
        VersionedDocument verDoc = this.getVersionedDocumentOfObjectId(so);
        ContentStream content = null;
        ObjectStore objStore = this.fStoreManager.getObjectStore(repositoryId);
        if (so instanceof DocumentVersion) {
            content = objStore.getContent(so, 0L, -1L);
        } else {
            DocumentVersion latestVer = ((VersionedDocument)so).getLatestVersion(false);
            content = objStore.getContent(latestVer, 0L, -1L);
        }
        if (verDoc.isCheckedOut()) {
            throw new CmisUpdateConflictException("Document " + (String)objectId.getValue() + " is already checked out.");
        }
        String user = context.getUsername();
        this.checkHasUser(user);
        DocumentVersion pwc = verDoc.checkOut(user);
        objectStore.setContent(pwc, content);
        objectStore.storeVersion(pwc);
        objectId.setValue((Object)pwc.getId());
        if (null != contentCopied) {
            contentCopied.setValue((Object)true);
        }
        if (context.isObjectInfoRequired()) {
            ObjectInfoImpl objectInfo = new ObjectInfoImpl();
            this.fAtomLinkProvider.fillInformationForAtomLinks(context, repositoryId, pwc, objectInfo);
            objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        }
    }

    public List<ObjectData> getAllVersions(CallContext context, String repositoryId, String objectId, String versionSeriesId, String filter, Boolean includeAllowableActions, ExtensionsData extension, ObjectInfoHandler objectInfos) {
        StoredObject so;
        ArrayList<ObjectData> res = new ArrayList<ObjectData>();
        String id = versionSeriesId;
        if (null == versionSeriesId) {
            if (null == objectId) {
                throw new CmisInvalidArgumentException("getAllVersions requires a version series id, but it was null.");
            }
            id = objectId;
        }
        if (!((so = this.validator.getAllVersions(context, repositoryId, objectId, id, extension)) instanceof VersionedDocument)) {
            if (!(so instanceof DocumentVersion)) {
                throw new CmisInvalidArgumentException("getAllVersions requires an id of a versioned document.");
            }
            so = ((DocumentVersion)so).getParentDocument();
        }
        VersionedDocument verDoc = (VersionedDocument)so;
        List<DocumentVersion> versions = verDoc.getAllVersions();
        for (DocumentVersion documentVersion : versions) {
            ObjectData objData = this.getObject(context, repositoryId, documentVersion.getId(), filter, includeAllowableActions, IncludeRelationships.NONE, false, extension, objectInfos);
            res.add(objData);
        }
        ArrayList<ObjectData> temp = new ArrayList<ObjectData>(res.size());
        for (ObjectData ver : res) {
            temp.add(0, ver);
        }
        res = temp;
        if (context.isObjectInfoRequired()) {
            ObjectInfoImpl objectInfoImpl = new ObjectInfoImpl();
            this.fAtomLinkProvider.fillInformationForAtomLinks(context, repositoryId, so, objectInfoImpl);
            objectInfos.addObjectInfo((ObjectInfo)objectInfoImpl);
        }
        return res;
    }

    public ObjectData getObjectOfLatestVersion(CallContext context, String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, String renditionFilter, Boolean includePolicyIds, Boolean includeAcl, ExtensionsData extension, ObjectInfoHandler objectInfos) {
        StoredObject so = this.validator.getObjectOfLatestVersion(context, repositoryId, objectId, versionSeriesId, extension);
        ObjectData objData = null;
        if (so instanceof DocumentVersion) {
            so = ((DocumentVersion)so).getParentDocument();
        }
        if (so instanceof VersionedDocument) {
            VersionedDocument verDoc = (VersionedDocument)so;
            DocumentVersion latestVersion = verDoc.getLatestVersion(major);
            objData = this.getObject(context, repositoryId, latestVersion.getId(), filter, includeAllowableActions, includeRelationships, includePolicyIds, extension, objectInfos);
        } else if (so instanceof Document) {
            objData = this.getObject(context, repositoryId, so.getId(), filter, includeAllowableActions, includeRelationships, includePolicyIds, extension, objectInfos);
        } else {
            throw new CmisInvalidArgumentException("Object is not instance of a document (version series)");
        }
        if (context.isObjectInfoRequired()) {
            ObjectInfoImpl objectInfo = new ObjectInfoImpl();
            this.fAtomLinkProvider.fillInformationForAtomLinks(context, repositoryId, so, objectInfo);
            objectInfos.addObjectInfo((ObjectInfo)objectInfo);
        }
        return objData;
    }

    public Properties getPropertiesOfLatestVersion(CallContext context, String repositoryId, String objectId, String versionSeriesId, Boolean major, String filter, ExtensionsData extension) {
        StoredObject so = this.validator.getPropertiesOfLatestVersion(context, repositoryId, objectId, versionSeriesId, extension);
        ObjectStore objectStore = this.fStoreManager.getObjectStore(repositoryId);
        StoredObject latestVersionObject = null;
        if (so instanceof DocumentVersion) {
            so = ((DocumentVersion)so).getParentDocument();
        }
        if (so instanceof VersionedDocument) {
            VersionedDocument verDoc = (VersionedDocument)so;
            latestVersionObject = verDoc.getLatestVersion(major);
        } else if (so instanceof Document) {
            latestVersionObject = so;
        } else {
            throw new CmisInvalidArgumentException("Object is not instance of a document (version series)");
        }
        List<String> requestedIds = FilterParser.getRequestedIdsFromFilter(filter);
        TypeManager tm = this.fStoreManager.getTypeManager(repositoryId);
        Properties props = PropertyCreationHelper.getPropertiesFromObject(latestVersionObject, objectStore, tm, requestedIds, true);
        return props;
    }

    private ObjectData getObject(CallContext context, String repositoryId, String objectId, String filter, Boolean includeAllowableActions, IncludeRelationships includeRelationships, Boolean includePolicies, ExtensionsData extension, ObjectInfoHandler objectInfos) {
        return this.fObjectService.getObject(context, repositoryId, objectId, filter, includeAllowableActions, includeRelationships, null, includePolicies, includeAllowableActions, extension, objectInfos);
    }
}

