/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.storedobj.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.data.LastModifiedContentStream;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.inmemory.storedobj.impl.RandomInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentStreamDataImpl
implements LastModifiedContentStream {
    private static final int SIZE_KB = 1024;
    private static final int BUFFER_SIZE = 65535;
    private static final Logger LOG = LoggerFactory.getLogger((String)ContentStreamDataImpl.class.getName());
    private static long totalLength = 0L;
    private static long totalCalls = 0L;
    private long fLength;
    private String fMimeType;
    private String fFileName;
    private byte[] fContent;
    private GregorianCalendar fLastModified;
    private long fStreamLimitOffset;
    private long fStreamLimitLength;
    private final long sizeLimitKB;
    private final boolean doNotStoreContent;

    private static synchronized long getTotalLength() {
        return totalLength;
    }

    private static synchronized void increaseTotalLength(long length) {
        totalLength += length;
    }

    private static synchronized void decreaseTotalLength(long length) {
        totalLength -= length;
    }

    private static synchronized long getTotalCalls() {
        return totalCalls;
    }

    private static synchronized void increaseTotalCalls() {
        ++totalCalls;
    }

    public ContentStreamDataImpl(long maxAllowedContentSizeKB) {
        this.sizeLimitKB = maxAllowedContentSizeKB;
        this.fLength = 0L;
        this.doNotStoreContent = false;
    }

    public ContentStreamDataImpl(long maxAllowedContentSizeKB, boolean doNotStore) {
        this.sizeLimitKB = maxAllowedContentSizeKB;
        this.fLength = 0L;
        this.doNotStoreContent = doNotStore;
    }

    public void setContent(InputStream in) throws IOException {
        this.fStreamLimitOffset = -1L;
        this.fStreamLimitLength = -1L;
        if (null == in) {
            this.fContent = null;
            this.fLength = 0L;
        } else {
            byte[] buffer = new byte[65535];
            ByteArrayOutputStream contentStream = new ByteArrayOutputStream();
            int len = in.read(buffer);
            while (len != -1) {
                if (!this.doNotStoreContent) {
                    contentStream.write(buffer, 0, len);
                }
                this.fLength += (long)len;
                if (this.sizeLimitKB > 0L && this.fLength > this.sizeLimitKB * 1024L) {
                    throw new CmisInvalidArgumentException("Content size exceeds max. allowed size of " + this.sizeLimitKB + "KB.");
                }
                len = in.read(buffer);
            }
            if (!this.doNotStoreContent) {
                this.fContent = contentStream.toByteArray();
                this.fLength = contentStream.size();
            }
            contentStream.close();
            in.close();
        }
        ContentStreamDataImpl.increaseTotalLength(this.fLength);
        ContentStreamDataImpl.increaseTotalCalls();
        LOG.debug("setting content stream, total no calls " + ContentStreamDataImpl.getTotalCalls() + ".");
        LOG.debug("setting content stream, new size total " + ContentStreamDataImpl.getTotalLength() / 0x100000L + "MB.");
    }

    public void appendContent(InputStream is) throws IOException {
        if (null == is) {
            return;
        }
        byte[] buffer = new byte[65535];
        ByteArrayOutputStream contentStream = new ByteArrayOutputStream();
        if (!this.doNotStoreContent) {
            contentStream.write(this.fContent);
        }
        ContentStreamDataImpl.decreaseTotalLength(this.fLength);
        int len = is.read(buffer);
        while (len != -1) {
            contentStream.write(buffer, 0, len);
            this.fLength += (long)len;
            if (this.sizeLimitKB > 0L && this.fLength > this.sizeLimitKB * 1024L) {
                throw new CmisInvalidArgumentException("Content size exceeds max. allowed size of " + this.sizeLimitKB + "KB.");
            }
            len = is.read(buffer);
        }
        if (!this.doNotStoreContent) {
            this.fContent = contentStream.toByteArray();
        }
        this.fLength = contentStream.size();
        contentStream.close();
        is.close();
        ContentStreamDataImpl.increaseTotalLength(this.fLength);
        ContentStreamDataImpl.increaseTotalCalls();
        LOG.debug("setting content stream, total no calls " + ContentStreamDataImpl.getTotalCalls() + ".");
        LOG.debug("setting content stream, new size total " + ContentStreamDataImpl.getTotalLength() / 0x100000L + "MB.");
    }

    public long getLength() {
        return this.fLength;
    }

    public BigInteger getBigLength() {
        return BigInteger.valueOf(this.fLength);
    }

    public String getMimeType() {
        return this.fMimeType;
    }

    public void setMimeType(String mimeType) {
        this.fMimeType = mimeType;
    }

    public String getFileName() {
        return this.fFileName;
    }

    public void setFileName(String fileName) {
        this.fFileName = fileName;
    }

    public String getFilename() {
        return this.fFileName;
    }

    public InputStream getStream() {
        if (this.doNotStoreContent) {
            return new RandomInputStream(this.fLength);
        }
        if (null == this.fContent) {
            return null;
        }
        if (this.fStreamLimitOffset <= 0L && this.fStreamLimitLength < 0L) {
            return new ByteArrayInputStream(this.fContent);
        }
        return new ByteArrayInputStream(this.fContent, (int)(this.fStreamLimitOffset < 0L ? 0L : this.fStreamLimitOffset), (int)(this.fStreamLimitLength < 0L ? this.fLength : this.fStreamLimitLength));
    }

    public void setLastModified(GregorianCalendar lastModified) {
        this.fLastModified = lastModified;
    }

    public GregorianCalendar getLastModified() {
        return this.fLastModified;
    }

    public ContentStream getCloneWithLimits(long offset, long length) {
        ContentStreamDataImpl clone = new ContentStreamDataImpl(0L, this.doNotStoreContent);
        clone.fFileName = this.fFileName;
        clone.fLength = length < 0L ? this.fLength - offset : Math.min(this.fLength - offset, length);
        clone.fContent = this.fContent;
        clone.fMimeType = this.fMimeType;
        clone.fStreamLimitOffset = offset;
        clone.fStreamLimitLength = clone.fLength;
        clone.fLastModified = this.fLastModified;
        return clone;
    }

    public final byte[] getBytes() {
        return this.fContent;
    }

    public List<CmisExtensionElement> getExtensions() {
        return null;
    }

    public void setExtensions(List<CmisExtensionElement> extensions) {
    }
}

