/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.rop;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.openjpa.lib.rop.AbstractNonSequentialResultList;
import org.apache.openjpa.lib.rop.ResultObjectProvider;

public class SimpleResultList
extends AbstractNonSequentialResultList {
    private final transient ResultObjectProvider _rop;
    private boolean _closed = false;
    private int _size = -1;

    public SimpleResultList(ResultObjectProvider rop) {
        this._rop = rop;
        try {
            this._rop.open();
        }
        catch (RuntimeException re) {
            this.close();
            throw re;
        }
        catch (Exception e) {
            this.close();
            this._rop.handleCheckedException(e);
        }
    }

    @Override
    public boolean isProviderOpen() {
        return !this._closed;
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public void close() {
        if (!this._closed) {
            this._closed = true;
            try {
                this._rop.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public Object getInternal(int index) {
        try {
            if (!this._rop.absolute(index)) {
                return PAST_END;
            }
            return this._rop.getResultObject();
        }
        catch (RuntimeException re) {
            this.close();
            throw re;
        }
        catch (Exception e) {
            this.close();
            this._rop.handleCheckedException(e);
            return PAST_END;
        }
    }

    @Override
    public int size() {
        this.assertOpen();
        if (this._size != -1) {
            return this._size;
        }
        try {
            this._size = this._rop.size();
            return this._size;
        }
        catch (RuntimeException re) {
            this.close();
            throw re;
        }
        catch (Exception e) {
            this.close();
            this._rop.handleCheckedException(e);
            return -1;
        }
    }

    public Object writeReplace() throws ObjectStreamException {
        if (this._closed) {
            return this;
        }
        ArrayList list = new ArrayList();
        Iterator itr = this.iterator();
        while (itr.hasNext()) {
            list.add(itr.next());
        }
        return list;
    }
}

