/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Enumeration;
import org.apache.bval.MetaBeanFactory;
import org.apache.bval.model.MetaBean;
import org.apache.bval.model.MetaProperty;

public class IntrospectorMetaBeanFactory
implements MetaBeanFactory {
    @Override
    public void buildMetaBean(MetaBean meta) throws Exception {
        if (meta.getBeanClass() == null) {
            return;
        }
        BeanInfo info = Introspector.getBeanInfo(meta.getBeanClass());
        if (meta.getName() == null && info.getBeanDescriptor() != null) {
            meta.setName(info.getBeanDescriptor().getName());
        }
        for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
            if (pd instanceof IndexedPropertyDescriptor || pd.getName().equals("class")) continue;
            MetaProperty metaProp = this.buildMetaProperty(pd, meta.getProperty(pd.getName()));
            meta.putProperty(pd.getName(), metaProp);
        }
    }

    @Deprecated
    protected MetaProperty buildMetaProperty(PropertyDescriptor pd) {
        return this.buildMetaProperty(pd, null);
    }

    protected MetaProperty buildMetaProperty(PropertyDescriptor pd, MetaProperty existing) {
        MetaProperty meta = new MetaProperty();
        meta.setName(pd.getName());
        meta.setType(this.determineGenericPropertyType(pd));
        if (pd.isHidden()) {
            meta.putFeature("hidden", Boolean.TRUE);
        }
        if (pd.isPreferred()) {
            meta.putFeature("preferred", Boolean.TRUE);
        }
        if (pd.isConstrained()) {
            meta.putFeature("readonly", Boolean.TRUE);
        }
        Enumeration<String> enumeration = pd.attributeNames();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement();
            Object value = pd.getValue(key);
            meta.putFeature(key, value);
        }
        return meta;
    }

    private Type determineGenericPropertyType(PropertyDescriptor pd) {
        Method m = pd.getReadMethod();
        if (m != null) {
            return m.getGenericReturnType();
        }
        m = pd.getWriteMethod();
        if (m != null && m.getParameterTypes().length == 1) {
            return m.getGenericParameterTypes()[0];
        }
        return pd.getPropertyType();
    }
}

