/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.netflix.ribbon.apache;

import java.io.IOException;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.util.EntityUtils;
import org.springframework.cloud.client.loadbalancer.RetryableStatusCodeException;

public class HttpClientStatusCodeException
extends RetryableStatusCodeException {
    private BasicHttpResponse response;

    public HttpClientStatusCodeException(String serviceId, HttpResponse response, HttpEntity entity, URI uri) throws IOException {
        super(serviceId, response.getStatusLine().getStatusCode(), (Object)response, uri);
        this.response = new BasicHttpResponse(response.getStatusLine());
        this.response.setLocale(response.getLocale());
        this.response.setStatusCode(response.getStatusLine().getStatusCode());
        this.response.setReasonPhrase(response.getStatusLine().getReasonPhrase());
        this.response.setHeaders(response.getAllHeaders());
        EntityUtils.updateEntity((HttpResponse)this.response, (HttpEntity)entity);
    }

    public HttpResponse getResponse() {
        return this.response;
    }
}

