/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.ribbon.proxy;

import com.netflix.ribbon.CacheProvider;
import com.netflix.ribbon.RibbonRequest;
import com.netflix.ribbon.proxy.ProxyAnnotationException;
import com.netflix.ribbon.proxy.annotation.Content;
import com.netflix.ribbon.proxy.annotation.ContentTransformerClass;
import com.netflix.ribbon.proxy.annotation.TemplateName;
import com.netflix.ribbon.proxy.annotation.Var;
import io.netty.buffer.ByteBuf;
import io.reactivex.netty.channel.ContentTransformer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import rx.Observable;

class MethodTemplate {
    private final Method method;
    private final String templateName;
    private final String[] paramNames;
    private final int[] valueIdxs;
    private final int contentArgPosition;
    private final Class<? extends ContentTransformer<?>> contentTansformerClass;
    private final Class<?> resultType;
    private final Class<?> genericContentType;

    MethodTemplate(Method method) {
        this.method = method;
        MethodAnnotationValues values = new MethodAnnotationValues(method);
        this.templateName = values.templateName;
        this.paramNames = values.paramNames;
        this.valueIdxs = values.valueIdxs;
        this.contentArgPosition = values.contentArgPosition;
        this.contentTansformerClass = values.contentTansformerClass;
        this.resultType = values.resultType;
        this.genericContentType = values.genericContentType;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getParamName(int idx) {
        return this.paramNames[idx];
    }

    public int getParamPosition(int idx) {
        return this.valueIdxs[idx];
    }

    public int getParamSize() {
        return this.paramNames.length;
    }

    public int getContentArgPosition() {
        return this.contentArgPosition;
    }

    public Class<? extends ContentTransformer<?>> getContentTransformerClass() {
        return this.contentTansformerClass;
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public Class<?> getGenericContentType() {
        return this.genericContentType;
    }

    public static <T> MethodTemplate[] from(Class<T> clientInterface) {
        ArrayList<MethodTemplate> list = new ArrayList<MethodTemplate>(clientInterface.getMethods().length);
        for (Method m : clientInterface.getMethods()) {
            list.add(new MethodTemplate(m));
        }
        return list.toArray(new MethodTemplate[list.size()]);
    }

    private static class MethodAnnotationValues {
        private final Method method;
        private String templateName;
        private String[] paramNames;
        private int[] valueIdxs;
        private int contentArgPosition;
        private Class<? extends ContentTransformer<?>> contentTansformerClass;
        private Class<?> resultType;
        private Class<?> genericContentType;

        private MethodAnnotationValues(Method method) {
            this.method = method;
            this.extractTemplateName();
            this.extractParamNamesWithIndexes();
            this.extractContentArgPosition();
            this.extractContentTransformerClass();
            this.extractResultType();
        }

        private void extractParamNamesWithIndexes() {
            ArrayList<String> nameList = new ArrayList<String>();
            ArrayList<Integer> idxList = new ArrayList<Integer>();
            Annotation[][] params = this.method.getParameterAnnotations();
            for (int i = 0; i < params.length; ++i) {
                for (Annotation a : params[i]) {
                    if (!a.annotationType().equals(Var.class)) continue;
                    String name = ((Var)a).value();
                    nameList.add(name);
                    idxList.add(i);
                }
            }
            int size = nameList.size();
            this.paramNames = new String[size];
            this.valueIdxs = new int[size];
            for (int i = 0; i < size; ++i) {
                this.paramNames[i] = (String)nameList.get(i);
                this.valueIdxs[i] = (Integer)idxList.get(i);
            }
        }

        private void extractContentArgPosition() {
            ParameterizedType pType;
            Type type;
            Annotation[][] params = this.method.getParameterAnnotations();
            int pos = -1;
            int count = 0;
            for (int i = 0; i < params.length; ++i) {
                for (Annotation a : params[i]) {
                    if (!a.annotationType().equals(Content.class)) continue;
                    pos = i;
                    ++count;
                }
            }
            if (count > 1) {
                throw new ProxyAnnotationException(String.format("Method %s annotates multiple parameters as @Content - at most one is allowed ", this.methodName()));
            }
            this.contentArgPosition = pos;
            if (this.contentArgPosition >= 0 && (type = this.method.getGenericParameterTypes()[this.contentArgPosition]) instanceof ParameterizedType && (pType = (ParameterizedType)type).getActualTypeArguments() != null) {
                this.genericContentType = (Class)pType.getActualTypeArguments()[0];
            }
        }

        private void extractContentTransformerClass() {
            ContentTransformerClass annotation = this.method.getAnnotation(ContentTransformerClass.class);
            if (this.contentArgPosition == -1) {
                if (annotation != null) {
                    throw new ProxyAnnotationException(String.format("ContentTransformClass defined on method %s with no @Content parameter", this.method.getName()));
                }
                return;
            }
            if (annotation == null) {
                Class<?> contentType = this.method.getParameterTypes()[this.contentArgPosition];
                if (Observable.class.isAssignableFrom(contentType) && ByteBuf.class.isAssignableFrom(this.genericContentType) || ByteBuf.class.isAssignableFrom(contentType) || byte[].class.isAssignableFrom(contentType) || String.class.isAssignableFrom(contentType)) {
                    return;
                }
                throw new ProxyAnnotationException(String.format("ContentTransformerClass annotation missing for content type %s in method %s", contentType.getName(), this.methodName()));
            }
            this.contentTansformerClass = annotation.value();
        }

        private void extractTemplateName() {
            TemplateName annotation = this.method.getAnnotation(TemplateName.class);
            this.templateName = null != annotation ? annotation.value() : this.method.getName();
        }

        private void extractResultType() {
            Class<RibbonRequest> returnClass = this.method.getReturnType();
            if (!returnClass.isAssignableFrom(RibbonRequest.class)) {
                throw new ProxyAnnotationException(String.format("Method %s must return RibbonRequest<ByteBuf> type not %s", this.methodName(), returnClass.getSimpleName()));
            }
            ParameterizedType returnType = (ParameterizedType)this.method.getGenericReturnType();
            this.resultType = (Class)returnType.getActualTypeArguments()[0];
            if (!ByteBuf.class.isAssignableFrom(this.resultType)) {
                throw new ProxyAnnotationException(String.format("Method %s must return RibbonRequest<ByteBuf> type; instead %s type parameter found", this.methodName(), this.resultType.getSimpleName()));
            }
        }

        private String methodName() {
            return this.method.getDeclaringClass().getSimpleName() + '.' + this.method.getName();
        }
    }

    static class CacheProviderEntry {
        private final String key;
        private final CacheProvider cacheProvider;

        CacheProviderEntry(String key, CacheProvider cacheProvider) {
            this.key = key;
            this.cacheProvider = cacheProvider;
        }

        public String getKey() {
            return this.key;
        }

        public CacheProvider getCacheProvider() {
            return this.cacheProvider;
        }
    }
}

