/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.filter;

import com.netflix.config.DynamicPropertyFactory;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.MicroserviceVersionMeta;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.foundation.common.cache.VersionedCache;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.serviceregistry.RegistryUtils;
import org.apache.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.serviceregistry.consumer.AppManager;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceVersion;
import org.apache.servicecomb.serviceregistry.consumer.MicroserviceVersions;
import org.apache.servicecomb.serviceregistry.discovery.AbstractDiscoveryFilter;
import org.apache.servicecomb.serviceregistry.discovery.DiscoveryContext;
import org.apache.servicecomb.serviceregistry.discovery.DiscoveryTreeNode;
import org.apache.servicecomb.serviceregistry.version.VersionRule;
import org.apache.servicecomb.serviceregistry.version.VersionRuleUtils;

public class OperationInstancesDiscoveryFilter
extends AbstractDiscoveryFilter {
    private static final String VERSION_RULE = "versionRule";

    public int getOrder() {
        return -10000;
    }

    public boolean enabled() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.loadbalance.filter.operation.enabled", true).get();
    }

    public boolean isGroupingFilter() {
        return true;
    }

    protected String findChildName(DiscoveryContext context, DiscoveryTreeNode parent) {
        Invocation invocation = (Invocation)((Object)context.getInputParameters());
        return invocation.getMicroserviceQualifiedName();
    }

    public void init(DiscoveryContext context, DiscoveryTreeNode parent) {
        Map<MicroserviceVersionMeta, Map<String, MicroserviceInstance>> versionMap = this.groupByVersion((Invocation)((Object)context.getInputParameters()), (Map)parent.data());
        Map<String, DiscoveryTreeNode> operationNodes = this.initOperationNodes(parent, versionMap);
        this.fillInstances(operationNodes, versionMap);
        parent.children(operationNodes);
    }

    protected void fillInstances(Map<String, DiscoveryTreeNode> operationNodes, Map<MicroserviceVersionMeta, Map<String, MicroserviceInstance>> versionMap) {
        for (Map.Entry<MicroserviceVersionMeta, Map<String, MicroserviceInstance>> entry : versionMap.entrySet()) {
            for (DiscoveryTreeNode node : operationNodes.values()) {
                VersionRule versionRule = (VersionRule)node.attribute(VERSION_RULE);
                if (!versionRule.isAccept(entry.getKey().getVersion())) continue;
                node.mapData().putAll(entry.getValue());
            }
        }
    }

    protected Map<String, DiscoveryTreeNode> initOperationNodes(DiscoveryTreeNode parent, Map<MicroserviceVersionMeta, Map<String, MicroserviceInstance>> versionMap) {
        ConcurrentHashMapEx tmpChildren = new ConcurrentHashMapEx();
        versionMap.keySet().stream().sorted(Comparator.comparing(MicroserviceVersion::getVersion)).forEach(arg_0 -> OperationInstancesDiscoveryFilter.lambda$initOperationNodes$1((Map)tmpChildren, parent, arg_0));
        return tmpChildren;
    }

    protected Map<MicroserviceVersionMeta, Map<String, MicroserviceInstance>> groupByVersion(Invocation invocation, Map<String, MicroserviceInstance> instances) {
        OperationMeta latestOperationMeta = invocation.getOperationMeta();
        MicroserviceMeta latestMicroserviceMeta = latestOperationMeta.getSchemaMeta().getMicroserviceMeta();
        AppManager appManager = RegistryUtils.getServiceRegistry().getAppManager();
        MicroserviceVersions MicroserviceVersions2 = appManager.getOrCreateMicroserviceVersions(latestMicroserviceMeta.getAppId(), latestMicroserviceMeta.getName());
        IdentityHashMap<MicroserviceVersionMeta, Map<String, MicroserviceInstance>> versionMap = new IdentityHashMap<MicroserviceVersionMeta, Map<String, MicroserviceInstance>>();
        for (MicroserviceInstance instance : instances.values()) {
            MicroserviceVersionMeta versionMeta = (MicroserviceVersionMeta)MicroserviceVersions2.getVersion(instance.getServiceId());
            Map versionInstances = versionMap.computeIfAbsent(versionMeta, vm -> new HashMap());
            versionInstances.put(instance.getInstanceId(), instance);
        }
        return versionMap;
    }

    private static /* synthetic */ void lambda$initOperationNodes$1(Map tmpChildren, DiscoveryTreeNode parent, MicroserviceVersionMeta meta) {
        for (OperationMeta operationMeta : meta.getMicroserviceMeta().getOperations()) {
            tmpChildren.computeIfAbsent(operationMeta.getMicroserviceQualifiedName(), qualifiedName -> {
                VersionRule versionRule = VersionRuleUtils.getOrCreate((String)(meta.getVersion().getVersion() + "+"));
                return (DiscoveryTreeNode)new DiscoveryTreeNode().attribute(VERSION_RULE, (Object)versionRule).subName((VersionedCache)parent, versionRule.getVersionRule()).data(new HashMap());
            });
        }
    }
}

