/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.route;

import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.cloud.client.discovery.event.HeartbeatMonitor;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.cloud.client.discovery.event.ParentHeartbeatEvent;
import org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent;
import org.springframework.cloud.gateway.event.RefreshRoutesEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.util.Assert;

public class RouteRefreshListener
implements ApplicationListener<ApplicationEvent> {
    private HeartbeatMonitor monitor = new HeartbeatMonitor();
    private final ApplicationEventPublisher publisher;

    public RouteRefreshListener(ApplicationEventPublisher publisher) {
        Assert.notNull((Object)publisher, (String)"publisher may not be null");
        this.publisher = publisher;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent || event instanceof RefreshScopeRefreshedEvent || event instanceof InstanceRegisteredEvent) {
            this.reset();
        } else if (event instanceof ParentHeartbeatEvent) {
            ParentHeartbeatEvent e = (ParentHeartbeatEvent)event;
            this.resetIfNeeded(e.getValue());
        } else if (event instanceof HeartbeatEvent) {
            HeartbeatEvent e = (HeartbeatEvent)event;
            this.resetIfNeeded(e.getValue());
        }
    }

    private void resetIfNeeded(Object value) {
        if (this.monitor.update(value)) {
            this.reset();
        }
    }

    private void reset() {
        this.publisher.publishEvent((ApplicationEvent)new RefreshRoutesEvent(this));
    }
}

