/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.support;

import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.style.ToStringCreator;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;

public class HttpStatusHolder {
    private final HttpStatus httpStatus;
    private final Integer status;

    public static HttpStatusHolder parse(String status) {
        HttpStatus httpStatus = ServerWebExchangeUtils.parse(status);
        Integer intStatus = httpStatus == null ? Integer.valueOf(Integer.parseInt(status)) : null;
        return new HttpStatusHolder(httpStatus, intStatus);
    }

    public HttpStatusHolder(HttpStatus httpStatus, Integer status) {
        Assert.isTrue((httpStatus != null || status != null ? 1 : 0) != 0, (String)"httpStatus and status may not both be null");
        this.httpStatus = httpStatus;
        this.status = status;
    }

    public HttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    public Integer getStatus() {
        return this.status;
    }

    public boolean is1xxInformational() {
        return HttpStatus.Series.INFORMATIONAL.equals((Object)this.getSeries());
    }

    public boolean is2xxSuccessful() {
        return HttpStatus.Series.SUCCESSFUL.equals((Object)this.getSeries());
    }

    public boolean is3xxRedirection() {
        return HttpStatus.Series.REDIRECTION.equals((Object)this.getSeries());
    }

    public boolean is4xxClientError() {
        return HttpStatus.Series.CLIENT_ERROR.equals((Object)this.getSeries());
    }

    public boolean is5xxServerError() {
        return HttpStatus.Series.SERVER_ERROR.equals((Object)this.getSeries());
    }

    public HttpStatus.Series getSeries() {
        if (this.httpStatus != null) {
            return this.httpStatus.series();
        }
        if (this.status != null) {
            return HttpStatus.Series.valueOf((int)this.status);
        }
        return null;
    }

    public boolean isError() {
        return this.is4xxClientError() || this.is5xxServerError();
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("httpStatus", (Object)this.httpStatus).append("status", (Object)this.status).toString();
    }
}

