/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.authentication;

public class RSAAuthenticationToken {
    public static final long TOKEN_ACTIVE_TIME = 86400000L;
    private String instanceId;
    private String serviceId;
    private long generateTime;
    private String randomCode;
    private String sign;
    private String tokenFormat;

    public RSAAuthenticationToken(String instanceId, String serviceId, long generateTime, String randomCode, String sign) {
        this.instanceId = instanceId;
        this.generateTime = generateTime;
        this.randomCode = randomCode;
        this.serviceId = serviceId;
        this.sign = sign;
        this.tokenFormat = String.format("%s@%s@%s@%s@%s", instanceId, serviceId, generateTime, randomCode, sign);
    }

    public String plainToken() {
        return String.format("%s@%s@%s@%s", this.instanceId, this.serviceId, this.generateTime, this.randomCode);
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public long getGenerateTime() {
        return this.generateTime;
    }

    public String getSign() {
        return this.sign;
    }

    public String format() {
        return this.tokenFormat;
    }

    public static RSAAuthenticationToken fromStr(String token) {
        String[] tokenArr = token.split("@");
        if (tokenArr.length != 5) {
            return null;
        }
        return new RSAAuthenticationToken(tokenArr[0], tokenArr[1], Long.valueOf(tokenArr[2]), tokenArr[3], tokenArr[4]);
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RSAAuthenticationToken)) {
            return false;
        }
        RSAAuthenticationToken token = (RSAAuthenticationToken)obj;
        if (!token.plainToken().equals(this.plainToken())) {
            return false;
        }
        return token.getSign().equals(this.sign);
    }

    public int hashCode() {
        return this.plainToken().hashCode() + this.sign.hashCode();
    }
}

