/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.pojo;

import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.swagger.converter.ConverterMgr;
import org.apache.servicecomb.swagger.generator.core.AbstractSwaggerGeneratorContext;
import org.apache.servicecomb.swagger.generator.core.OperationGenerator;
import org.apache.servicecomb.swagger.generator.core.utils.ClassUtils;
import org.apache.servicecomb.swagger.generator.core.utils.ParamUtils;
import org.apache.servicecomb.swagger.generator.pojo.converter.parameter.PendingBodyParameterConverter;
import org.apache.servicecomb.swagger.generator.pojo.extend.parameter.PendingBodyParameter;
import org.apache.servicecomb.swagger.generator.pojo.processor.parameter.PojoDefaultParameterProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PojoSwaggerGeneratorContext
extends AbstractSwaggerGeneratorContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(PojoSwaggerGeneratorContext.class);

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean canProcess(Class<?> cls) {
        for (Annotation annotation : cls.getAnnotations()) {
            if (!"javax.ws.rs.Path".equals(annotation.annotationType().getCanonicalName()) && !"org.springframework.web.bind.annotation.RequestMapping".equals(annotation.annotationType().getCanonicalName())) continue;
            LOGGER.info("There is @RequestMapping or @Path annotation on the REST interface class, but POJO swagger context is chosen. If this is unexpected, maybe you should check your dependency jar files.");
        }
        return true;
    }

    @Override
    public boolean canProcess(Method method) {
        return true;
    }

    @Override
    protected void initDefaultParameterProcessor() {
        this.defaultParameterProcessor = new PojoDefaultParameterProcessor();
    }

    protected void correctPath(OperationGenerator operationGenerator) {
        String path = operationGenerator.getPath();
        if (StringUtils.isEmpty((CharSequence)path)) {
            path = "/" + operationGenerator.getOperation().getOperationId();
        }
        operationGenerator.setPath(path);
    }

    protected void handlePendingBody(OperationGenerator operationGenerator) {
        List<BodyParameter> bodyParameters = this.collectBodyBasedParameters(operationGenerator);
        if (bodyParameters.isEmpty()) {
            return;
        }
        if (bodyParameters.size() == 1) {
            Parameter bodyParameter = (Parameter)bodyParameters.get(0);
            this.replaceBodyBasedParameter(operationGenerator, bodyParameter);
            return;
        }
        this.mergeBodyBasedParameters(operationGenerator, bodyParameters);
    }

    protected List<BodyParameter> collectBodyBasedParameters(OperationGenerator operationGenerator) {
        ArrayList<BodyParameter> bodyParameters = new ArrayList<BodyParameter>();
        for (Parameter parameter : operationGenerator.getSwaggerParameters()) {
            if (!BodyParameter.class.isInstance(parameter)) continue;
            bodyParameters.add((BodyParameter)parameter);
        }
        return bodyParameters;
    }

    protected void replaceBodyBasedParameter(OperationGenerator operationGenerator, Parameter bodyBasedParameter) {
        if (ParamUtils.isRealBodyParameter(bodyBasedParameter)) {
            return;
        }
        List<Parameter> swaggerParameters = operationGenerator.getSwaggerParameters();
        int idx = swaggerParameters.indexOf(bodyBasedParameter);
        String bodyParamName = bodyBasedParameter.getName();
        BodyParameter bodyParameter = ((PendingBodyParameter)bodyBasedParameter).createBodyParameter(bodyParamName);
        swaggerParameters.set(idx, (Parameter)bodyParameter);
    }

    protected void mergeBodyBasedParameters(OperationGenerator operationGenerator, List<BodyParameter> bodyParameters) {
        List<Parameter> swaggerParameters = operationGenerator.getSwaggerParameters();
        swaggerParameters.removeAll(bodyParameters);
        String bodyParamName = ParamUtils.generateBodyParameterName(operationGenerator.getProviderMethod());
        Class<?> cls = ClassUtils.getOrCreateBodyClass(operationGenerator, bodyParameters);
        BodyParameter bodyParameter = ParamUtils.createBodyParameter(operationGenerator.getSwagger(), bodyParamName, cls);
        swaggerParameters.add((Parameter)bodyParameter);
    }

    protected void correctHttpMethod(OperationGenerator operationGenerator) {
        if (StringUtils.isEmpty((CharSequence)operationGenerator.getHttpMethod())) {
            operationGenerator.setHttpMethod("POST");
        }
    }

    @Override
    public void postProcessOperation(OperationGenerator operationGenerator) {
        this.correctPath(operationGenerator);
        this.correctHttpMethod(operationGenerator);
        this.handlePendingBody(operationGenerator);
    }

    static {
        ConverterMgr.addConverter(PendingBodyParameter.class, new PendingBodyParameterConverter());
    }
}

