/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.exception.converter;

import jakarta.validation.ConstraintViolationException;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.exception.ExceptionConverter;
import org.apache.servicecomb.core.exception.converter.ValidateDetail;
import org.apache.servicecomb.swagger.invocation.exception.CommonExceptionData;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;

public class ConstraintViolationExceptionConverter
implements ExceptionConverter<ConstraintViolationException> {
    public static final int ORDER = Short.MAX_VALUE;
    public static final String KEY_CODE = "servicecomb.filters.validate.code";

    public int getOrder() {
        return Short.MAX_VALUE;
    }

    @Override
    public boolean canConvert(Throwable throwable) {
        return throwable instanceof ConstraintViolationException;
    }

    @Override
    public InvocationException convert(Invocation invocation, ConstraintViolationException throwable, Response.StatusType genericStatus) {
        List details = throwable.getConstraintViolations().stream().map(violation -> new ValidateDetail(violation.getPropertyPath().toString(), violation.getMessage())).collect(Collectors.toList());
        CommonExceptionData exceptionData = new CommonExceptionData((String)SCBEngine.getInstance().getEnvironment().getProperty(KEY_CODE, String.class, (Object)"SCB.00000003"), "invalid parameters.");
        exceptionData.putDynamic("validateDetail", details);
        return new InvocationException((Response.StatusType)Response.Status.BAD_REQUEST, (Object)exceptionData);
    }
}

