/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.provider;

import io.swagger.v3.oas.models.OpenAPI;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.servicecomb.core.provider.OpenAPIRegistry;
import org.apache.servicecomb.core.provider.OpenAPIRegistryManager;
import org.apache.servicecomb.registry.DiscoveryManager;
import org.apache.servicecomb.registry.api.DiscoveryInstance;
import org.apache.servicecomb.router.util.VersionCompareUtil;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;

public class RegistryOpenAPIRegistry
implements OpenAPIRegistry {
    private DiscoveryManager discoveryManager;
    private Environment environment;

    @Autowired
    public void setDiscoveryManager(DiscoveryManager discoveryManager) {
        this.discoveryManager = discoveryManager;
    }

    @Autowired
    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Override
    public boolean enabled() {
        return (Boolean)this.environment.getProperty("servicecomb.openAPI.registry.registry.enabled", Boolean.TYPE, (Object)false);
    }

    @Override
    public void registerOpenAPI(String application, String serviceName, String schemaId, OpenAPI api) {
    }

    @Override
    public Map<String, OpenAPI> loadOpenAPI(String application, String serviceName) {
        List discoveryInstances = this.discoveryManager.findServiceInstances(application, serviceName);
        if (discoveryInstances.isEmpty()) {
            throw new InvocationException((Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, "no instances");
        }
        discoveryInstances.sort((a, b) -> VersionCompareUtil.compareVersion((String)b.getVersion(), (String)a.getVersion()));
        HashMap<String, OpenAPI> result = new HashMap<String, OpenAPI>();
        String version = null;
        for (DiscoveryInstance instance : discoveryInstances) {
            if (version != null && !version.equals(instance.getVersion())) break;
            version = instance.getVersion();
            instance.getSchemas().forEach((k, v) -> result.computeIfAbsent((String)k, key -> SwaggerUtils.parseSwagger((String)v)));
        }
        return result;
    }

    @Override
    public void setOpenAPIChangeListener(OpenAPIRegistryManager.OpenAPIChangeListener listener) {
        this.discoveryManager.addInstanceChangeListener((registryName, application, serviceName, instances) -> {
            if (CollectionUtils.isEmpty((Collection)instances)) {
                return;
            }
            listener.onOpenAPIChanged(application, serviceName);
        });
    }

    public int getOrder() {
        return -8000;
    }
}

