/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.provider.consumer;

import io.swagger.v3.oas.models.OpenAPI;
import jakarta.ws.rs.core.Response;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.core.SCBEngine;
import org.apache.servicecomb.core.definition.ConsumerMicroserviceVersionsMeta;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.provider.OpenAPIRegistryManager;
import org.apache.servicecomb.core.provider.consumer.InvokerUtils;
import org.apache.servicecomb.core.provider.consumer.MicroserviceReferenceConfig;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.foundation.vertx.executor.VertxWorkerExecutor;
import org.apache.servicecomb.registry.definition.MicroserviceNameParser;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.springframework.beans.factory.annotation.Autowired;

public class ReferenceConfigManager {
    private final Map<String, Map<String, MicroserviceReferenceConfig>> referenceConfigs = new ConcurrentHashMapEx();
    private final Map<String, Map<String, Object>> referenceConfigsLocks = new ConcurrentHashMapEx();
    private OpenAPIRegistryManager openAPIRegistryManager;

    @Autowired
    public void setOpenAPIRegistryManager(OpenAPIRegistryManager openAPIRegistryManager) {
        this.openAPIRegistryManager = openAPIRegistryManager;
        this.openAPIRegistryManager.addOpenAPIChangeListener(this::onOpenAPIChanged);
    }

    private void onOpenAPIChanged(String application, String serviceName) {
        if (this.referenceConfigs.get(application) != null && this.referenceConfigs.get(application).get(serviceName) != null) {
            MicroserviceReferenceConfig config = this.buildMicroserviceReferenceConfig(SCBEngine.getInstance(), application, serviceName);
            this.referenceConfigs.get(application).put(serviceName, config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<MicroserviceReferenceConfig> getOrCreateReferenceConfigAsync(SCBEngine scbEngine, String qualifiedName) {
        MicroserviceNameParser parser = this.parseMicroserviceName(scbEngine, qualifiedName);
        MicroserviceReferenceConfig config = (MicroserviceReferenceConfig)this.referenceConfigs.computeIfAbsent(parser.getAppId(), app -> new ConcurrentHashMapEx()).get(parser.getMicroserviceName());
        if (config != null) {
            return CompletableFuture.completedFuture(config);
        }
        if (InvokerUtils.isInEventLoop()) {
            CompletableFuture<MicroserviceReferenceConfig> result = new CompletableFuture<MicroserviceReferenceConfig>();
            VertxWorkerExecutor executor = new VertxWorkerExecutor();
            executor.execute(() -> {
                Object object = this.referenceConfigsLocks.computeIfAbsent(parser.getAppId(), key -> new ConcurrentHashMapEx()).computeIfAbsent(parser.getMicroserviceName(), key -> new Object());
                synchronized (object) {
                    try {
                        MicroserviceReferenceConfig temp = this.referenceConfigs.get(parser.getAppId()).get(parser.getMicroserviceName());
                        if (temp != null) {
                            result.complete(temp);
                            return;
                        }
                        temp = this.buildMicroserviceReferenceConfig(scbEngine, parser.getAppId(), parser.getMicroserviceName());
                        this.referenceConfigs.get(parser.getAppId()).put(parser.getMicroserviceName(), temp);
                        result.complete(temp);
                    }
                    catch (Exception e) {
                        result.completeExceptionally(e);
                    }
                }
            });
            return result;
        }
        Object object = this.referenceConfigsLocks.computeIfAbsent(parser.getAppId(), key -> new ConcurrentHashMapEx()).computeIfAbsent(parser.getMicroserviceName(), key -> new Object());
        synchronized (object) {
            MicroserviceReferenceConfig temp = this.referenceConfigs.get(parser.getAppId()).get(parser.getMicroserviceName());
            if (temp != null) {
                return CompletableFuture.completedFuture(temp);
            }
            temp = this.buildMicroserviceReferenceConfig(scbEngine, parser.getAppId(), parser.getMicroserviceName());
            this.referenceConfigs.get(parser.getAppId()).put(parser.getMicroserviceName(), temp);
            return CompletableFuture.completedFuture(temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MicroserviceReferenceConfig getOrCreateReferenceConfig(SCBEngine scbEngine, String qualifiedName) {
        MicroserviceNameParser parser = this.parseMicroserviceName(scbEngine, qualifiedName);
        MicroserviceReferenceConfig config = (MicroserviceReferenceConfig)this.referenceConfigs.computeIfAbsent(parser.getAppId(), app -> new ConcurrentHashMapEx()).get(parser.getMicroserviceName());
        if (config == null) {
            Object object = this.referenceConfigsLocks.computeIfAbsent(parser.getAppId(), key -> new ConcurrentHashMapEx()).computeIfAbsent(parser.getMicroserviceName(), key -> new Object());
            synchronized (object) {
                config = this.referenceConfigs.get(parser.getAppId()).get(parser.getMicroserviceName());
                if (config != null) {
                    return config;
                }
                config = this.buildMicroserviceReferenceConfig(scbEngine, parser.getAppId(), parser.getMicroserviceName());
                this.referenceConfigs.get(parser.getAppId()).put(parser.getMicroserviceName(), config);
                return config;
            }
        }
        return config;
    }

    private MicroserviceNameParser parseMicroserviceName(SCBEngine scbEngine, String microserviceName) {
        return new MicroserviceNameParser(scbEngine.getAppId(), microserviceName);
    }

    private MicroserviceReferenceConfig buildMicroserviceReferenceConfig(SCBEngine engine, String application, String microserviceName) {
        ConsumerMicroserviceVersionsMeta microserviceVersionsMeta = new ConsumerMicroserviceVersionsMeta(engine);
        MicroserviceMeta microserviceMeta = new MicroserviceMeta(engine, application, microserviceName, true);
        microserviceMeta.setConsumerFilterChain(engine.getFilterChainsManager().findConsumerChain(application, microserviceName));
        microserviceMeta.setEdgeFilterChain(engine.getFilterChainsManager().findEdgeChain(application, microserviceName));
        microserviceMeta.setMicroserviceVersionsMeta(microserviceVersionsMeta);
        Map<String, OpenAPI> schemas = this.openAPIRegistryManager.loadOpenAPI(application, microserviceName);
        for (Map.Entry<String, OpenAPI> entry : schemas.entrySet()) {
            OpenAPI swagger = entry.getValue();
            if (swagger != null) {
                microserviceMeta.registerSchemaMeta(entry.getKey(), entry.getValue());
                continue;
            }
            throw new InvocationException((Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, String.format("Swagger %s/%s/%s can not be empty or load swagger failed.", application, microserviceName, entry.getKey()));
        }
        EventManager.getEventBus().post((Object)new SCBEngine.CreateMicroserviceMetaEvent(microserviceMeta));
        return new MicroserviceReferenceConfig(application, microserviceName, microserviceMeta);
    }
}

