/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance.filter;

import org.apache.servicecomb.core.Endpoint;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.Transport;
import org.apache.servicecomb.core.registry.discovery.EndpointDiscoveryFilter;
import org.apache.servicecomb.loadbalance.ServiceCombServer;
import org.apache.servicecomb.registry.api.DiscoveryInstance;
import org.apache.servicecomb.registry.discovery.DiscoveryContext;
import org.apache.servicecomb.registry.discovery.StatefulDiscoveryInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerDiscoveryFilter
extends EndpointDiscoveryFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerDiscoveryFilter.class);

    protected Object createEndpoint(DiscoveryContext context, String transportName, String endpoint, StatefulDiscoveryInstance instance) {
        Transport transport = this.scbEngine.getTransportManager().findTransport(transportName);
        if (transport == null) {
            LOGGER.info("not deployed transport {}, ignore {}.", (Object)transportName, (Object)endpoint);
            return null;
        }
        Invocation invocation = (Invocation)context.getInputParameters();
        return new ServiceCombServer(invocation.getMicroserviceName(), new Endpoint(transport, endpoint, (DiscoveryInstance)instance));
    }
}

