/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core.processor.parameter;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.swagger.extend.annotations.RawJsonRequestBody;
import org.apache.servicecomb.swagger.generator.OperationGenerator;
import org.apache.servicecomb.swagger.generator.ParameterGenerator;
import org.apache.servicecomb.swagger.generator.SwaggerGenerator;
import org.apache.servicecomb.swagger.generator.SwaggerParameterAnnotationProcessor;
import org.apache.servicecomb.swagger.generator.core.model.HttpParameterType;

public class RawJsonRequestBodyProcessor
extends SwaggerParameterAnnotationProcessor<RawJsonRequestBody> {
    @Override
    public Class<?> getProcessType() {
        return RawJsonRequestBody.class;
    }

    @Override
    public String getParameterName(RawJsonRequestBody annotation) {
        if (StringUtils.isNotEmpty((CharSequence)annotation.value())) {
            return annotation.value();
        }
        if (StringUtils.isNotEmpty((CharSequence)annotation.name())) {
            return annotation.name();
        }
        return null;
    }

    @Override
    public void process(SwaggerGenerator swaggerGenerator, OperationGenerator operationGenerator, ParameterGenerator parameterGenerator, RawJsonRequestBody annotation) {
        parameterGenerator.setHttpParameterType(HttpParameterType.BODY);
        if (StringUtils.isNotEmpty((CharSequence)this.getParameterName(annotation))) {
            parameterGenerator.getParameterGeneratorContext().setParameterName(this.getParameterName(annotation));
        }
        parameterGenerator.getParameterGeneratorContext().setRequired(annotation.required());
        parameterGenerator.getParameterGeneratorContext().setRawJson(true);
        parameterGenerator.getParameterGeneratorContext().updateConsumes(Arrays.asList("application/json", "text/plain"));
    }
}

