/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.accessLog.core.element.impl;

import io.vertx.core.http.Cookie;
import io.vertx.ext.web.RoutingContext;
import java.util.Map;
import java.util.Set;
import org.apache.servicecomb.common.accessLog.core.element.AccessLogItem;
import org.apache.servicecomb.core.event.InvocationFinishEvent;
import org.apache.servicecomb.core.event.ServerAccessLogEvent;
import org.apache.servicecomb.transport.rest.client.RestClientRequestParameters;

public class CookieAccessItem
implements AccessLogItem<RoutingContext> {
    public static final String RESULT_NOT_FOUND = "-";
    private final String varName;

    public CookieAccessItem(String varName) {
        this.varName = varName;
    }

    @Override
    public void appendServerFormattedItem(ServerAccessLogEvent accessLogEvent, StringBuilder builder) {
        Set cookies = accessLogEvent.getRoutingContext().request().cookies();
        if (null == cookies) {
            builder.append(RESULT_NOT_FOUND);
            return;
        }
        for (Cookie cookie : cookies) {
            if (!this.varName.equals(cookie.getName())) continue;
            builder.append(cookie.getValue());
            return;
        }
        builder.append(RESULT_NOT_FOUND);
    }

    @Override
    public void appendClientFormattedItem(InvocationFinishEvent finishEvent, StringBuilder builder) {
        RestClientRequestParameters restRequestImpl = (RestClientRequestParameters)finishEvent.getInvocation().getHandlerContext().get("servicecomb-invocation-handler-requestclient");
        if (null == restRequestImpl || null == restRequestImpl.getCookieMap()) {
            builder.append(RESULT_NOT_FOUND);
            return;
        }
        for (Map.Entry entry : restRequestImpl.getCookieMap().entrySet()) {
            if (!((String)entry.getKey()).equals(this.varName)) continue;
            builder.append((String)entry.getValue());
            return;
        }
        builder.append(RESULT_NOT_FOUND);
    }

    public String getVarName() {
        return this.varName;
    }
}

