/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.servicecomb.registry.nacos;

public class NacosConst {
  public static final String PROPERTY_VERSION = "scb-version";

  public static final String PROPERTY_ALIAS = "scb-alias";

  public static final String PROPERTY_DESCRIPTION = "scb-description";

  public static final String PROPERTY_ENDPOINT = "scb-endpoint";

  public static final String PROPERTY_REGION = "scb-region";

  public static final String PROPERTY_ZONE = "scb-zone";

  public static final String PROPERTY_DATACENTER = "scb-datacenter";

  public static final String PROPERTY_SCHEMA_PREFIX = "scb-schema-";

  public static final String ENDPOINT_PROPERTY_SEPARATOR = ",";

  public static final String NACOS_REGISTRY_PREFIX = "servicecomb.registry.nacos";

  public static final String SERVER_ADDR = "serverAddr";

  public static final String USERNAME = "username";

  public static final String PASSWORD = "password";

  public static final String NAMESPACE = "namespace";

  public static final String NACOS_NAMING_LOG_NAME = "com.alibaba.nacos.naming.log.filename";

  public static final String ACCESS_KEY = "accessKey";

  public static final String SECRET_KEY = "secretKey";

  public static final String CLUSTER_NAME = "clusterName";

  public static final String NAMING_LOAD_CACHE_AT_START = "namingLoadCacheAtStart";

  public static final String NACOS_REGISTRY_NAME = "nacos-registry";

  public static final String NACOS_STATUS = "nacos-status";
}
