/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.internal.console;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import org.apache.sling.ide.eclipse.core.logger.LogSubscriber;
import org.apache.sling.ide.eclipse.ui.internal.Activator;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component
public class SlingConsoleLogger
implements LogSubscriber {
    private final Object sync = new Object();
    private IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
    private MessageConsole slingConsole;
    private IConsoleListener listener;

    @Activate
    public void activate() {
        this.consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        this.listener = new IConsoleListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void consolesRemoved(IConsole[] consoles) {
                Object object = SlingConsoleLogger.this.sync;
                synchronized (object) {
                    IConsole[] iConsoleArray = consoles;
                    int n = consoles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConsole console = iConsoleArray[n2];
                        if (console.equals(SlingConsoleLogger.this.slingConsole)) {
                            SlingConsoleLogger.this.slingConsole = null;
                        }
                        ++n2;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void consolesAdded(IConsole[] consoles) {
                Object object = SlingConsoleLogger.this.sync;
                synchronized (object) {
                    IConsole[] iConsoleArray = consoles;
                    int n = consoles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConsole console = iConsoleArray[n2];
                        if (console.getType().equals("Sling")) {
                            SlingConsoleLogger.this.slingConsole = (MessageConsole)console;
                            break;
                        }
                        ++n2;
                    }
                }
            }
        };
        this.consoleManager.addConsoleListener(this.listener);
    }

    @Deactivate
    public void deactivate() {
        this.consoleManager.removeConsoleListener(this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(LogSubscriber.Severity severity, String message, Throwable t) {
        Object object = this.sync;
        synchronized (object) {
            this.initSlingConsole();
            if (this.slingConsole != null) {
                this.log(severity, message, t, this.slingConsole);
            }
        }
    }

    private void initSlingConsole() {
        if (this.slingConsole == null) {
            IConsole[] iConsoleArray = this.consoleManager.getConsoles();
            int n = iConsoleArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConsole console = iConsoleArray[n2];
                if (console.getType().equals("Sling")) {
                    this.slingConsole = (MessageConsole)console;
                    return;
                }
                ++n2;
            }
        }
    }

    private void log(LogSubscriber.Severity severity, String message, Throwable t, MessageConsole console) {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (MessageConsoleStream messageStream = console.newMessageStream();){
                StringBuilder msgBuilder = new StringBuilder();
                msgBuilder.append("[").append(DateTimeFormatter.ISO_LOCAL_TIME.format(LocalTime.now())).append("] ").append(message);
                messageStream.write(message.toString());
                if (t != null) {
                    t.printStackTrace(new PrintStream((OutputStream)messageStream));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.getDefault().getPluginLogger().warn("Failed writing to the console", (Throwable)e);
        }
    }
}

