/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.ui.nav;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.sling.ide.eclipse.core.ProjectUtil;
import org.apache.sling.ide.eclipse.core.internal.ProjectHelper;
import org.apache.sling.ide.eclipse.ui.internal.Activator;
import org.apache.sling.ide.eclipse.ui.nav.model.JcrNode;
import org.apache.sling.ide.eclipse.ui.nav.model.SyncDir;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.IPipelinedTreeContentProvider2;
import org.eclipse.ui.navigator.PipelinedShapeModification;
import org.eclipse.ui.navigator.PipelinedViewerUpdate;

public class JcrContentContentProvider
implements ITreeContentProvider,
IPipelinedTreeContentProvider2,
IResourceChangeListener {
    private Object input;
    private TreeViewer viewer;

    public void resourceChanged(IResourceChangeEvent event) {
        if (this.viewer.getTree().isDisposed()) {
            return;
        }
        try {
            final HashSet toBeRefreshed = new HashSet();
            event.getDelta().accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    if (delta.getResource() instanceof IContainer) {
                        return true;
                    }
                    IProject p = delta.getResource().getProject();
                    IFolder syncDir = JcrContentContentProvider.this.getSyncDir(p);
                    if (syncDir == null) {
                        return false;
                    }
                    toBeRefreshed.add(syncDir.getProject());
                    return true;
                }
            });
            for (final IProject project : toBeRefreshed) {
                this.viewer.getTree().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (JcrContentContentProvider.this.viewer.getTree().isDisposed()) {
                            return;
                        }
                        long start = System.currentTimeMillis();
                        JcrContentContentProvider.this.viewer.refresh((Object)project, true);
                        long end = System.currentTimeMillis();
                        Activator.getDefault().getPluginLogger().tracePerformance("viewer.refresh({0},true)", end - start, new Object[]{project});
                    }
                });
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.input = newInput;
        this.viewer = (TreeViewer)viewer;
    }

    public Object[] getElements(Object inputElement) {
        return null;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IProject) {
            return this.projectGetChildren((IProject)parentElement);
        }
        if (parentElement instanceof JcrNode) {
            long start = System.currentTimeMillis();
            JcrNode node = (JcrNode)parentElement;
            Object[] children = node.getChildren(true);
            long end = System.currentTimeMillis();
            Activator.getDefault().getPluginLogger().tracePerformance("node.getChildren for node at {0}", end - start, new Object[]{node.getJcrPath()});
            return children;
        }
        return null;
    }

    private Object[] projectGetChildren(IProject parentElement) {
        IFolder syncDir = this.getSyncDir(parentElement);
        if (syncDir != null && syncDir.exists()) {
            return new Object[]{new SyncDir(syncDir)};
        }
        return null;
    }

    public Object getParent(Object element) {
        if (!(element instanceof JcrNode)) {
            return null;
        }
        if (element instanceof SyncDir) {
            SyncDir syncDir = (SyncDir)element;
            return syncDir.getFolder().getProject();
        }
        JcrNode node = (JcrNode)element;
        return node.getParent();
    }

    public boolean hasChildren(Object element) {
        if (element instanceof IProject) {
            return this.projectHasChildren((IProject)element);
        }
        if (element instanceof JcrNode) {
            JcrNode jcrNode = (JcrNode)element;
            return jcrNode.hasChildren();
        }
        return false;
    }

    private boolean projectHasChildren(IProject project) {
        IFolder syncDir = this.getSyncDir(project);
        return syncDir != null && syncDir.exists();
    }

    private IFolder getSyncDir(IProject project) {
        return ProjectUtil.getSyncDirectory((IProject)project);
    }

    public void getPipelinedElements(Object anInput, Set theCurrentElements) {
    }

    public Object getPipelinedParent(Object anObject, Object aSuggestedParent) {
        return aSuggestedParent;
    }

    public PipelinedShapeModification interceptAdd(PipelinedShapeModification anAddModification) {
        return anAddModification;
    }

    public PipelinedShapeModification interceptRemove(PipelinedShapeModification aRemoveModification) {
        return aRemoveModification;
    }

    public boolean interceptRefresh(PipelinedViewerUpdate aRefreshSynchronization) {
        return false;
    }

    public boolean interceptUpdate(PipelinedViewerUpdate anUpdateSynchronization) {
        return false;
    }

    public void init(ICommonContentExtensionSite aConfig) {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public void getPipelinedChildren(Object aParent, Set theCurrentChildren) {
        if (aParent instanceof IProject) {
            Object[] children;
            IProject project = (IProject)aParent;
            if (ProjectHelper.isContentProject((IProject)project)) {
                Iterator it = theCurrentChildren.iterator();
                while (it.hasNext()) {
                    Object aChild = it.next();
                    if (!(aChild instanceof IPackageFragmentRoot)) continue;
                    IPackageFragmentRoot ipfr = (IPackageFragmentRoot)aChild;
                    IResource res = ipfr.getResource();
                    IFolder syncDir = this.getSyncDir(project);
                    if (res == null || syncDir == null || !res.equals((Object)syncDir)) continue;
                    it.remove();
                    break;
                }
            }
            if ((children = this.projectGetChildren(project)) != null && children.length > 0) {
                theCurrentChildren.addAll(Arrays.asList(children));
            }
            return;
        }
        if (aParent instanceof SyncDir) {
            theCurrentChildren.clear();
            Object[] children = this.getChildren(aParent);
            if (children != null) {
                theCurrentChildren.addAll(Arrays.asList(children));
            }
        }
    }

    public boolean hasPipelinedChildren(Object anInput, boolean currentHasChildren) {
        if (anInput instanceof IResource) {
            return currentHasChildren;
        }
        return true;
    }
}

