/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.openid.impl;

import com.dyuproject.openid.OpenIdUser;
import com.dyuproject.openid.RelyingParty;
import com.dyuproject.openid.manager.CookieBasedUserManager;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.auth.core.AuthUtil;
import org.apache.sling.auth.core.spi.AbstractAuthenticationHandler;
import org.apache.sling.auth.core.spi.AuthenticationInfo;
import org.apache.sling.auth.core.spi.DefaultAuthenticationFeedbackHandler;
import org.apache.sling.auth.openid.OpenIDFailure;
import org.apache.sling.auth.openid.impl.OpenIDLoginModulePlugin;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=false, metatype=true, label="%auth.openid.name", description="%auth.openid.description", name="org.apache.sling.auth.openid.OpenIDAuthenticationHandler")
@Service
@org.apache.felix.scr.annotations.Properties(value={@Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="service.description", value={"Apache Sling OpenID Authentication Handler"}), @Property(name="path", value={"/"}, unbounded=PropertyUnbounded.ARRAY), @Property(name="authtype", value={"OpenID"}, propertyPrivate=true)})
public class OpenIDAuthenticationHandler
extends AbstractAuthenticationHandler {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Property(value={"/system/sling/openid/login"})
    public static final String PROP_LOGIN_FORM = "openid.login.form";
    public static final String DEFAULT_LOGIN_IDENTIFIER_FORM_FIELD = "openid_identifier";
    @Property(value={"openid_identifier"})
    public static final String PROP_LOGIN_IDENTIFIER_FORM_FIELD = "openid.login.identifier";
    public static final String DEFAULT_EXTERNAL_URL_PREFIX = "";
    @Property(value={""})
    public static final String PROP_EXTERNAL_URL_PREFIX = "openid.external.url.prefix";
    public static final boolean DEFAULT_USE_COOKIE = true;
    @Property(boolValue={true})
    public static final String PROP_USE_COOKIE = "openid.use.cookie";
    public static final String DEFAULT_COOKIE_DOMAIN = "";
    @Property(value={""})
    public static final String PROP_COOKIE_DOMAIN = "openid.cookie.domain";
    public static final String DEFAULT_COOKIE_NAME = "sling.openid";
    @Property(value={"sling.openid"})
    public static final String PROP_COOKIE_NAME = "openid.cookie.name";
    public static final String DEFAULT_COOKIE_SECRET_KEY = "secret";
    @Property(value={"secret"})
    public static final String PROP_COOKIE_SECRET_KEY = "openid.cookie.secret.key";
    private static final String DEFAULT_OPENID_USER_ATTR = "openid.user";
    @Property(value={"openid.user"})
    private static final String PROP_OPENID_USER_ATTR = "openid.user.attr";
    private static final String DEFAULT_OPEN_ID_IDENTIFIER_PROPERTY = "openid.identity";
    @Property(value={"openid.identity"})
    private static final String PROP_OPEN_ID_IDENTIFIER_PROPERTY = "openid.property.identity";
    private static final String ATTR_USER_ID = "jcr.userid";
    static final String SLASH = "/";
    @Reference
    private SlingRepository repository;
    private Session session;
    private UserManager userManager;
    private ComponentContext context;
    private String loginForm;
    private String externalUrlPrefix;
    private String realm;
    private boolean useCookie;
    private String cookieDomain;
    private char[] cookieSecret;
    private String cookieName;
    private String identifierParam;
    private String identityProperty;
    private String openIdAttribute;
    private RelyingParty relyingParty;
    private ServiceRegistration loginModule;

    public OpenIDAuthenticationHandler() {
        this.log.info("OpenIDAuthenticationHandler created");
    }

    public AuthenticationInfo extractCredentials(HttpServletRequest request, HttpServletResponse response) {
        block12: {
            try {
                String returnTo;
                String url;
                RelyingParty relyingParty = this.getRelyingParty(request);
                OpenIdUser user = this.discover(relyingParty, request);
                if (user == null) {
                    if (RelyingParty.isAuthResponse((HttpServletRequest)request)) {
                        this.log.debug("OpenID authentication timeout");
                        response.sendRedirect(request.getRequestURI());
                        return AuthenticationInfo.DOING_AUTH;
                    }
                    if (RelyingParty.isAuthCancel((HttpServletRequest)request)) {
                        this.log.info("OpenID authentication cancelled by user");
                        return this.handleAuthFailure(OpenIDFailure.AUTHENTICATION, request);
                    }
                    String identifier = request.getParameter(this.identifierParam);
                    if (identifier != null) {
                        this.log.info("OpenID authentication failed (probably failed to discover OpenID Provider)");
                        return this.handleAuthFailure(OpenIDFailure.DISCOVERY, request);
                    }
                    break block12;
                }
                if (user.isAuthenticated()) {
                    return this.getAuthInfoFromUser(user);
                }
                if (user.isAssociated()) {
                    if (RelyingParty.isAuthResponse((HttpServletRequest)request)) {
                        if (relyingParty.verifyAuth(user, request, response)) {
                            response.sendRedirect(this.getReturnToResource(request));
                            return AuthenticationInfo.DOING_AUTH;
                        }
                        return this.handleAuthFailure(OpenIDFailure.VERIFICATION, request);
                    }
                    relyingParty.invalidate(request, response);
                    return this.handleAuthFailure(OpenIDFailure.AUTHENTICATION, request);
                }
                String trustRoot = this.realm == null ? url : this.realm;
                if (relyingParty.associateAndAuthenticate(user, request, response, trustRoot, trustRoot, returnTo = (url = this.getBaseUrl(request)) + this.getReturnToPath(request))) {
                    return AuthenticationInfo.DOING_AUTH;
                }
                return this.handleAuthFailure(OpenIDFailure.ASSOCIATION, request);
            }
            catch (ClassCastException cce) {
                this.log.warn("extractCredentials: Found OpenID user data in HTTP Session which cannot be used; failing credentials extraction");
                this.log.debug("extractCredentials: dump", (Throwable)cce);
                this.dropCredentials(request, response);
                return this.handleAuthFailure(OpenIDFailure.OTHER, request);
            }
            catch (Exception e) {
                this.log.error("Error processing OpenID request", (Throwable)e);
            }
        }
        return null;
    }

    public boolean requestCredentials(HttpServletRequest request, HttpServletResponse response) throws IOException {
        Object paramIdentifier;
        if (this.ignoreRequestCredentials(request)) {
            return false;
        }
        if (!AuthUtil.checkReferer((HttpServletRequest)request, (String)this.loginForm)) {
            return false;
        }
        RelyingParty relyingParty = this.getRelyingParty(request);
        relyingParty.invalidate(request, response);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("resource", OpenIDAuthenticationHandler.getLoginResource((HttpServletRequest)request, null));
        if (request.getAttribute("j_reason") != null) {
            Object jReason = request.getAttribute("j_reason");
            String reason = jReason instanceof Enum ? ((Enum)jReason).name() : jReason.toString();
            params.put("j_reason", reason);
        }
        if ((paramIdentifier = request.getAttribute("j_openid_identity")) instanceof String) {
            params.put("j_openid_identity", (String)paramIdentifier);
        }
        try {
            OpenIDAuthenticationHandler.sendRedirect((HttpServletRequest)request, (HttpServletResponse)response, (String)this.loginForm, params);
        }
        catch (IOException e) {
            this.log.error("Failed to redirect to the login form " + this.loginForm, (Throwable)e);
        }
        return true;
    }

    public void dropCredentials(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.getRelyingParty(request).invalidate(request, response);
        }
        catch (Exception e) {
            this.log.warn("dropAuthentication: Problem checking whether the user is logged in at all, assuming not logged in and therefore not logging out");
        }
    }

    public void authenticationFailed(HttpServletRequest request, HttpServletResponse response, AuthenticationInfo authInfo) {
        OpenIdUser user = null;
        try {
            user = this.getRelyingParty(request).discover(request);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.dropCredentials(request, response);
        request.setAttribute("j_reason", (Object)OpenIDFailure.REPOSITORY);
        if (user != null && user.getIdentity() != null) {
            request.setAttribute("j_openid_identity", (Object)user.getIdentity());
        }
    }

    public boolean authenticationSucceeded(HttpServletRequest request, HttpServletResponse response, AuthenticationInfo authInfo) {
        return DefaultAuthenticationFeedbackHandler.handleRedirect((HttpServletRequest)request, (HttpServletResponse)response);
    }

    private OpenIdUser discover(RelyingParty relyingParty, HttpServletRequest request) {
        try {
            return relyingParty.discover(request);
        }
        catch (UnknownHostException uhe) {
            this.log.info("discover: The OpenID identifier cannot be resolved because it designates an unknown host {}", (Object)uhe.getMessage());
        }
        catch (IOException ioe) {
            this.log.info("discover: Failure to communicate with OpenID provider", (Throwable)ioe);
        }
        catch (ClassCastException cce) {
            throw cce;
        }
        catch (Exception e) {
            this.log.warn("discover: Unexpected failure discovering the OpenID user", (Throwable)e);
        }
        return null;
    }

    private AuthenticationInfo handleAuthFailure(OpenIDFailure failure, HttpServletRequest request) {
        request.setAttribute("j_reason", (Object)failure);
        return AuthenticationInfo.FAIL_AUTH;
    }

    protected void activate(ComponentContext componentContext) {
        this.context = componentContext;
        Dictionary props = this.context.getProperties();
        this.loginForm = OsgiUtil.toString(props.get(PROP_LOGIN_FORM), (String)"/system/sling/openid/login");
        this.externalUrlPrefix = OsgiUtil.toString(props.get(PROP_EXTERNAL_URL_PREFIX), (String)"");
        this.identityProperty = OsgiUtil.toString(props.get(PROP_OPEN_ID_IDENTIFIER_PROPERTY), (String)DEFAULT_OPEN_ID_IDENTIFIER_PROPERTY);
        this.useCookie = OsgiUtil.toBoolean(props.get(PROP_USE_COOKIE), (boolean)true);
        this.cookieDomain = OsgiUtil.toString(props.get(PROP_COOKIE_DOMAIN), (String)"");
        this.cookieName = OsgiUtil.toString(props.get(PROP_COOKIE_NAME), (String)DEFAULT_COOKIE_NAME);
        this.identifierParam = OsgiUtil.toString(props.get(PROP_LOGIN_IDENTIFIER_FORM_FIELD), (String)DEFAULT_LOGIN_IDENTIFIER_FORM_FIELD);
        this.cookieSecret = OsgiUtil.toString(props.get(PROP_COOKIE_SECRET_KEY), (String)DEFAULT_COOKIE_SECRET_KEY).toCharArray();
        this.openIdAttribute = OsgiUtil.toString(props.get(PROP_OPENID_USER_ATTR), (String)DEFAULT_OPENID_USER_ATTR);
        this.loginModule = null;
        try {
            this.loginModule = OpenIDLoginModulePlugin.register(this, componentContext.getBundleContext());
        }
        catch (Throwable t) {
            this.log.info("Cannot register OpenIDLoginModulePlugin. This is expected if Sling LoginModulePlugin services are not supported");
            this.log.debug("dump", t);
        }
    }

    protected void deactivate(ComponentContext componentContext) {
        if (this.loginModule != null) {
            this.loginModule.unregister();
            this.loginModule = null;
        }
        if (this.session != null) {
            try {
                if (this.session.isLive()) {
                    this.session.logout();
                }
            }
            catch (Throwable t) {
                this.log.error("deactivate: Unexpected problem logging out session", t);
            }
            this.userManager = null;
            this.session = null;
        }
    }

    private boolean ignoreRequestCredentials(HttpServletRequest request) {
        String requestLogin = request.getParameter("sling:authRequestLogin");
        return requestLogin != null && !"OpenID".equals(requestLogin);
    }

    private AuthenticationInfo getAuthInfoFromUser(OpenIdUser user) {
        AuthenticationInfo info = new AuthenticationInfo("OpenID", this.getUserName(user));
        if (this.loginModule == null) {
            info.put(this.openIdAttribute, (Object)user.getIdentity());
        } else {
            info.put(this.openIdAttribute, (Object)user);
        }
        return info;
    }

    OpenIdUser getOpenIdUser(Credentials credentials) {
        if (credentials instanceof SimpleCredentials) {
            SimpleCredentials creds = (SimpleCredentials)credentials;
            return (OpenIdUser)creds.getAttribute(this.openIdAttribute);
        }
        return null;
    }

    private String getUserName(OpenIdUser user) {
        Object nickname = user.getAttribute(ATTR_USER_ID);
        if (nickname instanceof String) {
            return (String)nickname;
        }
        String identity = user.getIdentity();
        String userId = null;
        UserManager userManager = this.getUserManager();
        if (userManager != null) {
            userId = this.getUserIdByProperty(userManager, this.identityProperty, identity);
        }
        if (userId == null) {
            userId = "::not_valid_for_login::";
        } else {
            user.setAttribute(ATTR_USER_ID, (Object)userId);
        }
        return userId;
    }

    private UserManager getUserManager() {
        if (this.userManager == null) {
            try {
                if (this.session == null) {
                    this.session = this.repository.loginAdministrative(null);
                }
                if (this.session instanceof JackrabbitSession) {
                    this.userManager = ((JackrabbitSession)this.session).getUserManager();
                }
            }
            catch (RepositoryException re) {
                this.log.error("getUserManager: Cannot get UserManager", (Throwable)re);
            }
        }
        return this.userManager;
    }

    private String getUserIdByProperty(UserManager userManager, String propName, String propValue) {
        String userId = null;
        try {
            Iterator users = userManager.findAuthorizables(propName, propValue, 1);
            if (users.hasNext()) {
                userId = ((User)users.next()).getID();
                if (users.hasNext()) {
                    this.log.warn("getUserName: Multiple users found with property {}={}; using {}", new Object[]{propName, propValue, userId});
                }
            }
        }
        catch (RepositoryException re) {
            this.log.warn("getUserName: Problem finding user with property {}={}", (Object)new Object[]{propName, propValue}, (Object)re);
        }
        return userId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RelyingParty getRelyingParty(HttpServletRequest request) {
        if (this.relyingParty == null) {
            Properties openIdProps = new Properties();
            openIdProps.setProperty("openid.identifier.parameter", this.identifierParam);
            if (this.useCookie) {
                String ctxPath = request.getContextPath();
                String cookiePath = ctxPath == null || ctxPath.length() == 0 ? SLASH : ctxPath;
                openIdProps.setProperty("openid.user.manager", CookieBasedUserManager.class.getName());
                openIdProps.setProperty("openid.user.manager.cookie.name", this.cookieName);
                openIdProps.setProperty("openid.user.manager.cookie.path", cookiePath);
                if (this.cookieDomain != null) {
                    openIdProps.setProperty("openid.user.manager.cookie.domain", this.cookieDomain);
                }
                openIdProps.setProperty("openid.user.manager.cookie.security.secret_key", new String(this.cookieSecret));
            }
            ClassLoader oldTCCL = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            try {
                this.relyingParty = RelyingParty.newInstance((Properties)openIdProps);
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldTCCL);
            }
        }
        return this.relyingParty;
    }

    String getBaseUrl(HttpServletRequest request) {
        if (this.externalUrlPrefix == null || this.externalUrlPrefix.length() == 0) {
            String scheme = request.getScheme();
            String host = request.getServerName();
            int port = request.getServerPort();
            String ctx = request.getContextPath();
            StringBuilder url = new StringBuilder();
            url.append(scheme).append("://");
            url.append(host);
            if (!(port <= 0 || "http".equals(scheme) && port == 80 || "https".equals(scheme) && port == 443)) {
                url.append(':').append(port);
            }
            url.append(ctx);
            return url.toString();
        }
        return this.externalUrlPrefix;
    }

    private String getReturnToPath(HttpServletRequest request) {
        String prefix;
        String resource = OpenIDAuthenticationHandler.getLoginResource((HttpServletRequest)request, null);
        if (resource == null) {
            resource = request.getRequestURI();
            if (request.getQueryString() != null) {
                resource = resource + "?" + request.getQueryString();
            }
        }
        return (prefix = request.getContextPath()).length() > 0 ? prefix.concat(resource) : resource;
    }

    private String getReturnToResource(HttpServletRequest request) {
        String resource = request.getRequestURI();
        if (request.getQueryString() != null) {
            return resource + "?" + request.getQueryString();
        }
        return resource;
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

