/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.bgservlets.impl.servlets;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.bgservlets.RuntimeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
@Property(name="sling.servlet.paths", value={"/system/bgservlets/test"})
public class BackgroundTestServlet
extends SlingAllMethodsServlet {
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/plain");
        PrintWriter w = response.getWriter();
        int cycles = this.getIntParam(request, "cycles", 10);
        int interval = this.getIntParam(request, "interval", 1000);
        int flushEvery = this.getIntParam(request, "flushEvery", 2);
        RuntimeState runtimeState = (RuntimeState)request.getAttribute(RuntimeState.class.getName());
        if (runtimeState == null) {
            this.log.warn("No RuntimeState attribute provided, won't report progress");
        } else {
            runtimeState.setEstimatedCompletionTime(new Date(System.currentTimeMillis() + (long)(cycles * interval)));
        }
        w.println("Start at " + new Date());
        try {
            for (int i = 1; i <= cycles; ++i) {
                if (i % flushEvery == 0) {
                    w.println("Flushing output<br/>");
                    w.flush();
                }
                String msg = String.format("Cycle %d of %d", i, cycles);
                w.printf(msg, new Object[0]);
                w.print("\n<br/>");
                if (runtimeState != null) {
                    runtimeState.setProgressMessage(msg);
                    int remainingCycles = cycles - i;
                    runtimeState.setEstimatedCompletionTime(new Date(System.currentTimeMillis() + (long)(remainingCycles * interval)));
                }
                try {
                    Thread.sleep(interval);
                    continue;
                }
                catch (InterruptedException iex) {
                    throw new ServletException("InterruptedException", (Throwable)iex);
                }
            }
            w.println("All done.");
            w.flush();
        }
        catch (Throwable t) {
            this.log.info("Exception in service method", t);
        }
    }

    private int getIntParam(SlingHttpServletRequest request, String name, int defaultValue) {
        int result = defaultValue;
        String str = request.getParameter(name);
        if (str != null) {
            result = Integer.parseInt(str);
        }
        return result;
    }
}

