/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.models;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.cms.core.internal.ResourceEditorAssociation;
import org.apache.sling.cms.core.internal.ResourceEditorAssociationProvider;
import org.apache.sling.cms.i18n.I18NProvider;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.osgi.annotation.versioning.ProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class})
@ProviderType
public class ContentBreadcrumb {
    private static final Logger log = LoggerFactory.getLogger(ContentBreadcrumb.class);
    private long depth;
    @OSGiService
    private ResourceEditorAssociationProvider associationProvider;
    private Resource resource;
    private final String rootTitle;

    @Inject
    public ContentBreadcrumb(SlingHttpServletRequest request, @OSGiService I18NProvider i18nProvider) {
        this.resource = request.getRequestPathInfo().getSuffixResource();
        log.debug("Loading configuration from {}", (Object)request.getResource().getValueMap());
        this.depth = (Long)request.getResource().getValueMap().get("depth", (Object)0L);
        String title = (String)request.getResource().getValueMap().get("rootTitle", String.class);
        this.rootTitle = title != null ? i18nProvider.getDictionary(request).get(title) : null;
    }

    public String getCurrentItem() {
        List<Pair<String, String>> parents = this.getParents();
        if ((parents == null || parents.isEmpty()) && StringUtils.isNotBlank((CharSequence)this.rootTitle)) {
            return this.rootTitle;
        }
        return this.getTitle(this.resource);
    }

    private String getLink(Resource resource) {
        log.debug("Getting link for {} from {}", (Object)resource, this.associationProvider.getAssociations());
        return this.associationProvider.getAssociations().stream().filter(a -> a.matches(resource)).findFirst().map(ResourceEditorAssociation::getEditor).orElse("/bin/browser.html") + resource.getPath();
    }

    public List<Pair<String, String>> getParents() {
        Resource parent;
        List<Object> ps = new ArrayList<Resource>();
        Resource current = this.resource;
        while ((parent = current.getParent()) != null) {
            ps.add(parent);
            current = parent;
        }
        Collections.reverse(ps);
        if (this.depth <= (long)ps.size()) {
            ps = ps.subList((int)this.depth, ps.size());
        } else {
            ps.clear();
        }
        List<Pair<String, String>> parents = ps.stream().map(p -> new ImmutablePair((Object)this.getLink((Resource)p), (Object)this.getTitle((Resource)p))).collect(Collectors.toList());
        if (!parents.isEmpty() && StringUtils.isNotBlank((CharSequence)this.rootTitle)) {
            parents.set(0, (Pair<String, String>)new ImmutablePair((Object)((String)parents.get(0).getLeft()), (Object)this.rootTitle));
        }
        return parents;
    }

    private String getTitle(Resource resource) {
        String title = (String)resource.getValueMap().get("jcr:title", String.class);
        if (StringUtils.isNotBlank((CharSequence)title)) {
            return title;
        }
        title = (String)resource.getValueMap().get("jcr:content/jcr:title", String.class);
        if (StringUtils.isNotBlank((CharSequence)title)) {
            return title;
        }
        return resource.getName();
    }
}

