/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.cms.core.models;

import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.annotations.Model;
import org.osgi.annotation.versioning.ProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class})
@ProviderType
public class StartContent {
    private static final Logger log = LoggerFactory.getLogger(StartContent.class);
    private final ResourceResolver resolver;
    private final String term;

    public StartContent(SlingHttpServletRequest request) {
        this.resolver = request.getResourceResolver();
        this.term = request.getParameter("q");
    }

    public List<Resource> getRelatedContent() {
        return this.getTenResults("SELECT * FROM [nt:hierarchyNode] AS s WHERE ISDESCENDANTNODE([/content]) AND CONTAINS(s.*,'" + this.escape(this.term).replaceAll("[\\Q+-&|!(){}[]^\"~*?:\\/\\E]", "") + "')");
    }

    public List<Resource> getRecentDrafts() {
        return Stream.concat(this.getTenResults("SELECT * FROM [sling:Page] WHERE [jcr:content/jcr:lastModifiedBy] = '" + this.escape(this.resolver.getUserID()) + "' AND ISDESCENDANTNODE([/content]) AND [jcr:content/sling:published] = false ORDER BY [jcr:content/jcr:lastModified] DESC").stream(), this.getTenResults("SELECT * FROM [sling:Page] WHERE [jcr:content/jcr:lastModifiedBy] = '" + this.escape(this.resolver.getUserID()) + "' AND ISDESCENDANTNODE([/content]) AND [jcr:content/sling:published] IS NULL ORDER BY [jcr:content/jcr:lastModified] DESC").stream()).sorted((r1, r2) -> ((Calendar)r2.getValueMap().get("jcr:content/jcr:lastModified", Calendar.class)).compareTo((Calendar)r1.getValueMap().get("jcr:content/jcr:lastModified", Calendar.class))).limit(10L).collect(Collectors.toList());
    }

    public List<Resource> getRecentContent() {
        return this.getTenResults("SELECT * FROM [nt:hierarchyNode] WHERE [jcr:content/jcr:lastModifiedBy] = '" + this.escape(this.resolver.getUserID()) + "' AND ISDESCENDANTNODE([/content]) ORDER BY [jcr:content/jcr:lastModified] DESC");
    }

    private String escape(String str) {
        return Optional.ofNullable(str).map(s -> s.replace("'", "''")).orElse("");
    }

    private List<Resource> getTenResults(String query) {
        log.debug("Executing query: {}", (Object)query);
        Iterator it = this.resolver.findResources(query, "JCR-SQL2");
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 256), false).limit(10L).collect(Collectors.toList());
    }
}

