/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.monitor.impl;

import java.io.InputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingDeque;
import javax.management.ObjectName;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.distribution.DistributionRequest;
import org.apache.sling.distribution.common.DistributionException;
import org.apache.sling.distribution.monitor.impl.DistributionPackageMBean;
import org.apache.sling.distribution.monitor.impl.DistributionPackageMBeanImpl;
import org.apache.sling.distribution.packaging.DistributionPackage;
import org.apache.sling.distribution.packaging.DistributionPackageBuilder;
import org.apache.sling.distribution.packaging.DistributionPackageInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public final class MonitoringDistributionPackageBuilder
implements DistributionPackageBuilder {
    private final DistributionPackageBuilder wrapped;
    private final BundleContext context;
    private final int queueCapacity;
    private final Queue<ServiceRegistration<DistributionPackageMBean>> mBeans;

    public MonitoringDistributionPackageBuilder(int queueCapacity, DistributionPackageBuilder wrapped, BundleContext context) {
        this.wrapped = wrapped;
        this.context = context;
        this.queueCapacity = queueCapacity;
        this.mBeans = new LinkedBlockingDeque<ServiceRegistration<DistributionPackageMBean>>();
    }

    @Override
    public String getType() {
        return this.wrapped.getType();
    }

    @Override
    @Nullable
    public DistributionPackage createPackage(@NotNull ResourceResolver resourceResolver, @NotNull DistributionRequest request) throws DistributionException {
        long start = System.currentTimeMillis();
        DistributionPackage distributionPackage = this.wrapped.createPackage(resourceResolver, request);
        if (this.queueCapacity > 0 && distributionPackage != null) {
            this.registerDistributionPackageMBean(start, distributionPackage);
        }
        return distributionPackage;
    }

    @Override
    @NotNull
    public DistributionPackage readPackage(@NotNull ResourceResolver resourceResolver, @NotNull InputStream stream) throws DistributionException {
        return this.wrapped.readPackage(resourceResolver, stream);
    }

    @Override
    public DistributionPackage getPackage(@NotNull ResourceResolver resourceResolver, @NotNull String id) throws DistributionException {
        return this.wrapped.getPackage(resourceResolver, id);
    }

    @Override
    public boolean installPackage(@NotNull ResourceResolver resourceResolver, @NotNull DistributionPackage distributionPackage) throws DistributionException {
        return this.wrapped.installPackage(resourceResolver, distributionPackage);
    }

    @Override
    @NotNull
    public DistributionPackageInfo installPackage(@NotNull ResourceResolver resourceResolver, @NotNull InputStream stream) throws DistributionException {
        return this.wrapped.installPackage(resourceResolver, stream);
    }

    private void registerDistributionPackageMBean(long start, DistributionPackage distributionPackage) {
        long processingTime = System.currentTimeMillis() - start;
        DistributionPackageMBeanImpl mBean = new DistributionPackageMBeanImpl(distributionPackage, this.wrapped.getType(), processingTime);
        Hashtable<String, String> mbeanProps = new Hashtable<String, String>();
        ((Dictionary)mbeanProps).put("jmx.objectname", "org.apache.sling.distribution:type=distributionpackage,id=" + ObjectName.quote(distributionPackage.getId()));
        ServiceRegistration mBeanRegistration = this.context.registerService(DistributionPackageMBean.class, (Object)mBean, mbeanProps);
        if (this.queueCapacity == this.mBeans.size()) {
            ServiceRegistration<DistributionPackageMBean> toBeRemoved = this.mBeans.poll();
            MonitoringDistributionPackageBuilder.safeUnregister(toBeRemoved);
        }
        this.mBeans.offer((ServiceRegistration<DistributionPackageMBean>)mBeanRegistration);
    }

    public void clear() {
        while (!this.mBeans.isEmpty()) {
            ServiceRegistration<DistributionPackageMBean> toBeRemoved = this.mBeans.poll();
            MonitoringDistributionPackageBuilder.safeUnregister(toBeRemoved);
        }
    }

    private static void safeUnregister(ServiceRegistration<?> serviceRegistration) {
        if (serviceRegistration != null) {
            serviceRegistration.unregister();
        }
    }
}

