/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.distribution.resources.impl.common;

public class SimplePathInfo {
    private final String resourcePathInfo;
    private final String resourceRoot;
    private final String mainResourceName;
    private final String childResourceName;

    private SimplePathInfo(String resourcePathInfo, String resourceRoot, String resourceName, String childResourceName) {
        this.resourcePathInfo = resourcePathInfo;
        this.resourceRoot = resourceRoot;
        this.mainResourceName = resourceName;
        this.childResourceName = childResourceName;
    }

    public String getResourcePathInfo() {
        return this.resourcePathInfo;
    }

    public String getMainResourceName() {
        return this.mainResourceName;
    }

    public String getChildResourceName() {
        return this.childResourceName;
    }

    public boolean isRoot() {
        return this.mainResourceName == null;
    }

    public boolean isMain() {
        return this.mainResourceName != null && this.childResourceName == null;
    }

    public boolean isChild() {
        return this.mainResourceName != null && this.childResourceName != null;
    }

    public String getResourcePath() {
        if (this.isRoot()) {
            return this.resourceRoot;
        }
        if (this.isMain()) {
            return this.resourceRoot + "/" + this.mainResourceName;
        }
        if (this.isChild()) {
            return this.resourceRoot + "/" + this.mainResourceName + "/" + this.childResourceName;
        }
        return null;
    }

    public static SimplePathInfo parsePathInfo(String resourceRoot, String requestPath) {
        int idx;
        int idx2;
        if (!requestPath.startsWith(resourceRoot)) {
            return null;
        }
        String resourceName = null;
        String resourcePathInfo = null;
        if (requestPath.startsWith(resourceRoot + "/")) {
            resourceName = requestPath.substring(resourceRoot.length() + 1);
            idx2 = resourceName.indexOf(".");
            if (idx2 >= 0) {
                resourcePathInfo = resourceName.substring(idx2);
                resourceName = resourceName.substring(0, idx2);
            }
        } else {
            idx2 = requestPath.indexOf(".");
            if (requestPath.contains(".")) {
                resourcePathInfo = requestPath.substring(idx2);
            }
        }
        String childResourceName = null;
        if (resourceName != null && (idx = resourceName.indexOf("/")) >= 0) {
            childResourceName = resourceName.substring(idx + 1);
            resourceName = resourceName.substring(0, idx);
        }
        return new SimplePathInfo(resourcePathInfo, resourceRoot, resourceName, childResourceName);
    }
}

