/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.base.internal.mount;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.jcr.Value;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.sling.jcr.base.internal.mount.ProxyJackrabbitSession;
import org.apache.sling.jcr.base.internal.mount.ProxySession;

public class ProxyRepository<T extends Repository>
implements Repository {
    public final T jcr;
    final T mount;
    final Set<String> mountPoints;

    public ProxyRepository(T jcr, T mount, Set<String> mountPoint) {
        this.jcr = jcr;
        this.mount = mount;
        this.mountPoints = new HashSet<String>(mountPoint);
    }

    public String[] getDescriptorKeys() {
        return this.jcr.getDescriptorKeys();
    }

    public boolean isStandardDescriptor(String key) {
        return this.jcr.isStandardDescriptor(key);
    }

    public boolean isSingleValueDescriptor(String key) {
        return this.jcr.isSingleValueDescriptor(key);
    }

    public Value getDescriptorValue(String key) {
        return this.jcr.getDescriptorValue(key);
    }

    public Value[] getDescriptorValues(String key) {
        return this.jcr.getDescriptorValues(key);
    }

    public String getDescriptor(String key) {
        return this.jcr.getDescriptor(key);
    }

    public Session login(Credentials credentials, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        Session mountSession;
        Session jcrSession = this.jcr.login(credentials, workspaceName);
        if (this.mount instanceof JackrabbitRepository) {
            HashMap<String, Session> attributes = new HashMap<String, Session>();
            attributes.put("org.apache.sling.jcr.base.RepositoryMount.PARENT_SESSION", jcrSession);
            mountSession = ((JackrabbitRepository)this.mount).login(credentials, workspaceName, attributes);
        } else {
            mountSession = this.mount.login(credentials, workspaceName);
        }
        return jcrSession instanceof JackrabbitSession ? new ProxyJackrabbitSession(this, (JackrabbitSession)jcrSession, mountSession, this.mountPoints) : new ProxySession<Session>(this, jcrSession, mountSession, this.mountPoints);
    }

    public Session login(Credentials credentials) throws LoginException, RepositoryException {
        return this.login(credentials, null);
    }

    public Session login(String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return this.login(null, workspaceName);
    }

    public Session login() throws LoginException, RepositoryException {
        return this.login(null, null);
    }

    public Session wrap(Session session) throws RepositoryException {
        if (session instanceof ProxySession) {
            return session;
        }
        HashMap<String, Session> attributes = new HashMap<String, Session>();
        attributes.put("org.apache.sling.jcr.base.RepositoryMount.PARENT_SESSION", session);
        Session mountSession = ((JackrabbitRepository)this.mount).login((Credentials)new SimpleCredentials(session.getUserID(), new char[0]), session.getWorkspace().getName(), attributes);
        return session instanceof JackrabbitSession ? new ProxyJackrabbitSession(this, (JackrabbitSession)session, mountSession, this.mountPoints) : new ProxySession<Session>(this, session, mountSession, this.mountPoints);
    }

    Session impersonate(Credentials credentials, Session jcr, Session mount) throws RepositoryException {
        return jcr instanceof JackrabbitSession ? new ProxyJackrabbitSession(this, (JackrabbitSession)jcr.impersonate(credentials), mount.impersonate(credentials), this.mountPoints) : new ProxySession<Session>(this, jcr.impersonate(credentials), mount.impersonate(credentials), this.mountPoints);
    }
}

