/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.performance;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.naming.directory.InvalidAttributesException;
import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.apache.sling.performance.IdentifiableTestCase;
import org.apache.sling.performance.IdentifiableTestClass;
import org.apache.sling.performance.PerformanceRunner;
import org.apache.sling.performance.PerformanceSuiteState;
import org.apache.sling.performance.ReportLogger;
import org.apache.sling.performance.annotation.AfterMethodInvocation;
import org.apache.sling.performance.annotation.BeforeMethodInvocation;
import org.apache.sling.performance.annotation.PerformanceTest;
import org.junit.After;
import org.junit.Before;
import org.junit.runners.model.FrameworkMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FrameworkPerformanceMethod
extends FrameworkMethod {
    private Object target;
    private PerformanceSuiteState performanceSuiteState;
    private PerformanceRunner.ReportLevel reportLevel = PerformanceRunner.ReportLevel.ClassLevel;
    private String referenceMethod = null;
    private String testCaseName = "";
    private String className;

    public FrameworkPerformanceMethod(Method method, Object target, PerformanceSuiteState performanceSuiteState, PerformanceRunner.ReportLevel reportLevel, String referenceMethod) {
        super(method);
        this.target = target;
        this.performanceSuiteState = performanceSuiteState;
        this.reportLevel = reportLevel;
        this.referenceMethod = referenceMethod;
        if (target instanceof IdentifiableTestCase) {
            this.testCaseName = ((IdentifiableTestCase)target).testCaseName();
        }
        String longClassName = this.target.getClass().getName();
        this.className = longClassName.substring(longClassName.lastIndexOf(".") + 1);
        if (target instanceof IdentifiableTestClass) {
            this.className = ((IdentifiableTestClass)target).testClassName();
        }
    }

    public Object invokeExplosively(Object target, Object ... params) throws Throwable {
        int invocationIndex;
        if (this.performanceSuiteState != null && this.performanceSuiteState.getBeforeSuiteMethod() != null && this.performanceSuiteState.getTargetObjectSuite() != null && this.performanceSuiteState.getNumberOfExecutedMethods() == 0 && !this.performanceSuiteState.testSuiteName.equals("TESTCASEONLY")) {
            this.performanceSuiteState.getBeforeSuiteMethod().invoke(this.performanceSuiteState.getTargetObjectSuite(), new Object[0]);
        }
        if (this.performanceSuiteState != null && !this.performanceSuiteState.testSuiteName.equals("TESTCASEONLY")) {
            this.recursiveCallSpecificMethod(this.target.getClass(), this.target, Before.class);
        }
        this.performanceSuiteState.incrementNumberOfExecutedTestMethods();
        Object response = null;
        Method testMethodToInvoke = this.getMethod();
        PerformanceTest performanceAnnotation = testMethodToInvoke.getAnnotation(PerformanceTest.class);
        int warmuptime = performanceAnnotation.warmuptime();
        int runtime = performanceAnnotation.runtime();
        int warmupinvocations = performanceAnnotation.warmupinvocations();
        int runinvocations = performanceAnnotation.runinvocations();
        double threshold = performanceAnnotation.threshold();
        DescriptiveStatistics statistics = new DescriptiveStatistics();
        if (warmupinvocations != 0) {
            for (invocationIndex = 0; invocationIndex < warmupinvocations; ++invocationIndex) {
                this.recursiveCallSpecificMethod(this.target.getClass(), this.target, BeforeMethodInvocation.class);
                response = super.invokeExplosively(this.target, params);
                this.recursiveCallSpecificMethod(this.target.getClass(), this.target, AfterMethodInvocation.class);
            }
        } else {
            long warmupEnd = System.currentTimeMillis() + (long)(warmuptime * 1000);
            while (System.currentTimeMillis() < warmupEnd) {
                this.recursiveCallSpecificMethod(this.target.getClass(), this.target, BeforeMethodInvocation.class);
                response = super.invokeExplosively(this.target, params);
                this.recursiveCallSpecificMethod(this.target.getClass(), this.target, AfterMethodInvocation.class);
            }
        }
        if (runinvocations != 0) {
            for (invocationIndex = 0; invocationIndex < runinvocations; ++invocationIndex) {
                response = this.invokeTimedTestMethod(testMethodToInvoke, statistics, params);
            }
        } else {
            long runtimeEnd = System.currentTimeMillis() + (long)(runtime * 1000);
            while (System.currentTimeMillis() < runtimeEnd) {
                response = this.invokeTimedTestMethod(testMethodToInvoke, statistics, params);
            }
        }
        if (statistics.getN() > 0L) {
            if (this.referenceMethod == null) {
                ReportLogger.writeReport(this.performanceSuiteState.testSuiteName, this.testCaseName, this.className, this.getMethod().getName(), statistics, ReportLogger.ReportType.TXT, this.reportLevel);
            } else {
                ReportLogger reportLogger = ReportLogger.getOrCreate(this.performanceSuiteState.testSuiteName, this.testCaseName, this.getMethod().getDeclaringClass().getName(), this.referenceMethod);
                reportLogger.recordStatistics(this.getMethod().getName(), statistics, threshold);
            }
        }
        if (this.performanceSuiteState != null && !this.performanceSuiteState.testSuiteName.equals("TESTCASEONLY")) {
            this.recursiveCallSpecificMethod(this.target.getClass(), this.target, After.class);
        }
        if (this.performanceSuiteState != null && this.performanceSuiteState.getAfterSuiteMethod() != null && this.performanceSuiteState.getTargetObjectSuite() != null && this.performanceSuiteState.getNumberOfExecutedMethods() == this.performanceSuiteState.getNumberOfMethodsInSuite() && !this.performanceSuiteState.testSuiteName.equals("TESTCASEONLY")) {
            this.performanceSuiteState.getAfterSuiteMethod().invoke(this.performanceSuiteState.getTargetObjectSuite(), new Object[0]);
        }
        return response;
    }

    private Object invokeTimedTestMethod(Method testMethodToInvoke, DescriptiveStatistics statistics, Object ... params) throws Throwable {
        Object response = null;
        this.recursiveCallSpecificMethod(this.target.getClass(), this.target, BeforeMethodInvocation.class);
        long start = System.nanoTime();
        response = super.invokeExplosively(this.target, params);
        long timeMilliseconds = TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        statistics.addValue((double)timeMilliseconds);
        this.recursiveCallSpecificMethod(this.target.getClass(), this.target, AfterMethodInvocation.class);
        return response;
    }

    private void recursiveCallSpecificMethod(Class test, Object instance, Class<? extends Annotation> methodAnnotation) throws InvocationTargetException, InvalidAttributesException, IllegalAccessException, InstantiationException {
        Method testMethod;
        if (test.getSuperclass() != null) {
            this.recursiveCallSpecificMethod(test.getSuperclass(), instance, methodAnnotation);
        }
        if ((testMethod = this.getSpecificTestMethod(test, methodAnnotation)) != null) {
            if (!testMethod.isAccessible()) {
                testMethod.setAccessible(true);
            }
            testMethod.invoke(instance, new Object[0]);
        }
    }

    private Method getSpecificTestMethod(Class testClass, Class<? extends Annotation> methodAnnotation) throws InvalidAttributesException, IllegalAccessException, InstantiationException {
        Method[] methodsToReturn = this.getSpecificMethods(testClass, methodAnnotation);
        Method methodToReturn = null;
        if (methodsToReturn.length == 1) {
            methodToReturn = methodsToReturn[0];
        } else if (methodsToReturn.length > 1) {
            throw new InvalidAttributesException("Only 1 non parameterized before method accepted");
        }
        return methodToReturn;
    }

    private Method[] getSpecificMethods(Class testClass, Class<? extends Annotation> annotation) {
        Method[] allMethods = testClass.getDeclaredMethods();
        ArrayList<Method> methodListResult = new ArrayList<Method>();
        for (Method testMethod : allMethods) {
            if (!testMethod.isAnnotationPresent(annotation)) continue;
            methodListResult.add(testMethod);
        }
        return methodListResult.toArray(new Method[0]);
    }

    public String getName() {
        if (this.testCaseName == null || "".equals(this.testCaseName.trim())) {
            return super.getName();
        }
        return String.format("%s  [%s.%s]", this.testCaseName, this.target.getClass().getSimpleName(), this.getMethod().getName());
    }
}

