/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.query.impl.resource;

import java.util.function.Predicate;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.query.impl.predicate.SelectorOperator;
import org.apache.sling.query.impl.selector.parser.Attribute;

public class ResourcePropertyPredicate
implements Predicate<Resource> {
    private final String key;
    private final String value;
    private final SelectorOperator operator;

    public ResourcePropertyPredicate(Attribute attribute) {
        this.key = attribute.getKey();
        this.value = attribute.getValue();
        this.operator = SelectorOperator.getSelectorOperator(attribute.getOperator());
    }

    @Override
    public boolean test(Resource resource) {
        Resource property = resource.getChild(this.key);
        if (property == null) {
            return false;
        }
        if (this.value == null) {
            return true;
        }
        return this.isEqualToValue(property);
    }

    private boolean isEqualToValue(Resource property) {
        String[] multiProperty = (String[])property.adaptTo(String[].class);
        if (multiProperty != null) {
            for (String p : multiProperty) {
                if (!this.operator.accepts(p, this.value)) continue;
                return true;
            }
            return false;
        }
        return this.operator.accepts((String)property.adaptTo(String.class), this.value);
    }
}

