/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.compiler.frontend;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.sling.scripting.sightly.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.compiler.expression.MarkupContext;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperation;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.BinaryOperator;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.StringConstant;
import org.apache.sling.scripting.sightly.impl.compiler.PushStream;
import org.apache.sling.scripting.sightly.impl.compiler.frontend.Fragment;
import org.apache.sling.scripting.sightly.impl.compiler.frontend.Interpolation;
import org.apache.sling.scripting.sightly.impl.filter.AbstractFilter;
import org.apache.sling.scripting.sightly.impl.filter.ExpressionContext;
import org.apache.sling.scripting.sightly.impl.filter.Filter;

public class ExpressionWrapper {
    private final List<Filter> filters;
    private final Set<String> knownOptions;
    private final PushStream stream;

    public ExpressionWrapper(PushStream stream, List<Filter> filters, Set<String> knownExpressionOptions) {
        this.stream = stream;
        this.filters = filters;
        this.knownOptions = knownExpressionOptions;
    }

    public Expression transform(Interpolation interpolation, MarkupContext markupContext, ExpressionContext expressionContext) {
        ArrayList<ExpressionNode> nodes = new ArrayList<ExpressionNode>();
        HashMap<String, ExpressionNode> options = new HashMap<String, ExpressionNode>();
        for (Fragment fragment : interpolation.getFragments()) {
            if (fragment.isString()) {
                nodes.add(new StringConstant(fragment.getText()));
                continue;
            }
            Expression expression = fragment.getExpression();
            if (AbstractFilter.NON_PARAMETRIZABLE_CONTEXTS.contains((Object)expressionContext)) {
                expression.getOptions().keySet().stream().filter(option -> !this.knownOptions.contains(option)).forEach(unknownOption -> this.stream.warn(new PushStream.StreamMessage(String.format("Unknown option '%s'.", unknownOption), expression.getRawText())));
            }
            Expression transformed = this.adjustToContext(expression, markupContext, expressionContext);
            nodes.add(transformed.getRoot());
            options.putAll(transformed.getOptions());
        }
        ExpressionNode root = this.join(nodes);
        if (interpolation.size() > 1) {
            options.remove("context");
        }
        return new Expression(root, options, interpolation.getContent());
    }

    private Expression applyFilters(Expression expression, ExpressionContext expressionContext) {
        Expression result = expression;
        for (Filter filter : this.filters) {
            result = filter.apply(result, expressionContext);
        }
        return result;
    }

    public Expression adjustToContext(Expression expression, MarkupContext context, ExpressionContext expressionContext) {
        if (context != null && !expression.containsOption("context")) {
            expression.getOptions().put("context", new StringConstant(context.getName()));
        }
        return this.applyFilters(expression, expressionContext);
    }

    private ExpressionNode join(List<ExpressionNode> nodes) {
        if (nodes.isEmpty()) {
            return StringConstant.EMPTY;
        }
        ExpressionNode root = nodes.remove(0);
        for (ExpressionNode node : nodes) {
            root = new BinaryOperation(BinaryOperator.CONCATENATE, root, node);
        }
        return root;
    }
}

