/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.plugin;

import java.util.HashMap;
import java.util.Map;
import org.apache.sling.scripting.sightly.compiler.commands.OutputVariable;
import org.apache.sling.scripting.sightly.compiler.commands.VariableBinding;
import org.apache.sling.scripting.sightly.compiler.expression.Expression;
import org.apache.sling.scripting.sightly.compiler.expression.ExpressionNode;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.MapLiteral;
import org.apache.sling.scripting.sightly.compiler.expression.nodes.RuntimeCall;
import org.apache.sling.scripting.sightly.impl.compiler.Patterns;
import org.apache.sling.scripting.sightly.impl.compiler.PushStream;
import org.apache.sling.scripting.sightly.impl.compiler.frontend.CompilerContext;
import org.apache.sling.scripting.sightly.impl.plugin.AbstractPlugin;
import org.apache.sling.scripting.sightly.impl.plugin.DefaultPluginInvoke;
import org.apache.sling.scripting.sightly.impl.plugin.PluginCallInfo;
import org.apache.sling.scripting.sightly.impl.plugin.PluginInvoke;

public class ResourcePlugin
extends AbstractPlugin {
    public ResourcePlugin() {
        this.name = "resource";
    }

    @Override
    public PluginInvoke invoke(final Expression expression, PluginCallInfo callInfo, final CompilerContext compilerContext) {
        return new DefaultPluginInvoke(){
            private Map<String, ExpressionNode> expressionOptions;
            {
                this.expressionOptions = new HashMap<String, ExpressionNode>(expression.getOptions());
            }

            @Override
            public void beforeChildren(PushStream stream) {
                String resourceVar = compilerContext.generateVariable("resourceContent");
                stream.write(new VariableBinding.Start(resourceVar, new RuntimeCall("includeResource", expression.getRoot(), new MapLiteral(this.expressionOptions))));
                stream.write(new OutputVariable(resourceVar));
                stream.write(VariableBinding.END);
                Patterns.beginStreamIgnore(stream);
            }

            @Override
            public void afterChildren(PushStream stream) {
                Patterns.endStreamIgnore(stream);
            }
        };
    }
}

