/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.get.impl.util;

import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.sling.api.request.RecursionTooDeepException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.servlets.get.impl.util.JsonObjectCreator;

public class ResourceTraversor {
    Map<Resource, List<Resource>> tree = new HashMap<Resource, List<Resource>>();
    private long count;
    private long maxResources;
    private final int maxRecursionLevels;
    private final JsonObjectBuilder startObject;
    private LinkedList<Resource> currentQueue;
    private LinkedList<Resource> nextQueue;
    private final Resource startResource;
    private boolean ecmaSupport;

    public ResourceTraversor(int levels, long maxResources, Resource resource, boolean ecmaSupport) {
        this.maxResources = maxResources;
        this.maxRecursionLevels = levels;
        this.startResource = resource;
        this.currentQueue = new LinkedList();
        this.nextQueue = new LinkedList();
        this.ecmaSupport = ecmaSupport;
        this.startObject = this.adapt(resource);
    }

    public int collectResources() throws RecursionTooDeepException {
        return this.collectChildren(this.startResource, 0);
    }

    private int collectChildren(Resource resource, int currentLevel) {
        if (this.maxRecursionLevels == -1 || currentLevel < this.maxRecursionLevels) {
            Iterator children = resource.listChildren();
            List<Resource> childTree = this.tree.get(resource);
            if (childTree == null) {
                childTree = new ArrayList<Resource>();
                this.tree.put(resource, childTree);
            }
            while (children.hasNext()) {
                ++this.count;
                Resource child = (Resource)children.next();
                if (this.count > this.maxResources && this.maxRecursionLevels != 1) {
                    return currentLevel;
                }
                this.nextQueue.addLast(child);
                childTree.add(child);
            }
        }
        if (currentLevel > 0) {
            return -1;
        }
        while (!this.currentQueue.isEmpty() || !this.nextQueue.isEmpty()) {
            int maxLevel;
            if (this.currentQueue.isEmpty()) {
                ++currentLevel;
                this.currentQueue = this.nextQueue;
                this.nextQueue = new LinkedList();
            }
            if ((maxLevel = this.collectChildren(this.currentQueue.removeFirst(), currentLevel)) == -1) continue;
            return maxLevel;
        }
        return -1;
    }

    private JsonObjectBuilder adapt(Resource resource) {
        return new JsonObjectCreator(resource, this.ecmaSupport).create();
    }

    public JsonObject getJSONObject() {
        return this.addChildren(this.startResource, this.startObject).build();
    }

    private JsonObjectBuilder addChildren(Resource resource, JsonObjectBuilder builder) {
        List<Resource> children = this.tree.get(resource);
        if (children != null) {
            for (Resource child : children) {
                builder.add(child.getName(), this.addChildren(child, this.adapt(child)));
            }
        }
        return builder;
    }
}

