/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.osgi.junit5;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.function.Consumer;
import org.apache.sling.testing.mock.osgi.context.OsgiContextImpl;
import org.apache.sling.testing.mock.osgi.junit5.OsgiContext;
import org.apache.sling.testing.mock.osgi.junit5.OsgiContextStore;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

public final class OsgiContextExtension
implements ParameterResolver,
TestInstancePostProcessor,
BeforeEachCallback,
AfterEachCallback,
AfterTestExecutionCallback {
    public void postProcessTestInstance(Object testInstance, ExtensionContext extensionContext) throws Exception {
        Field osgiContextField = this.getFieldFromTestInstance(testInstance, OsgiContext.class);
        if (osgiContextField != null) {
            OsgiContext context = (OsgiContext)((Object)osgiContextField.get(testInstance));
            if (context != null) {
                if (!context.isSetUp()) {
                    context.setUpContext();
                }
                OsgiContextStore.storeOsgiContext(extensionContext, testInstance, context);
            } else {
                context = OsgiContextStore.getOrCreateOsgiContext(extensionContext, testInstance);
                osgiContextField.set(testInstance, (Object)context);
            }
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return OsgiContext.class.isAssignableFrom(parameterContext.getParameter().getType());
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return OsgiContextStore.getOrCreateOsgiContext(extensionContext, extensionContext.getRequiredTestInstance());
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        this.applyOsgiContext(extensionContext, osgiContext -> osgiContext.getContextPlugins().executeAfterSetUpCallback((OsgiContextImpl)osgiContext));
    }

    public void afterTestExecution(ExtensionContext extensionContext) throws Exception {
        this.applyOsgiContext(extensionContext, osgiContext -> osgiContext.getContextPlugins().executeBeforeTearDownCallback((OsgiContextImpl)osgiContext));
    }

    public void afterEach(ExtensionContext extensionContext) {
        this.applyOsgiContext(extensionContext, osgiContext -> {
            osgiContext.getContextPlugins().executeAfterTearDownCallback((OsgiContextImpl)osgiContext);
            osgiContext.tearDownContext();
            OsgiContextStore.removeOsgiContext(extensionContext, extensionContext.getRequiredTestInstance());
        });
    }

    private void applyOsgiContext(ExtensionContext extensionContext, Consumer<OsgiContext> consumer) {
        OsgiContext osgiContext = OsgiContextStore.getOsgiContext(extensionContext, extensionContext.getRequiredTestInstance());
        if (osgiContext != null) {
            consumer.accept(osgiContext);
        }
    }

    private Field getFieldFromTestInstance(Object testInstance, Class<?> type) {
        return this.getFieldFromTestInstance(testInstance.getClass(), type);
    }

    private Field getFieldFromTestInstance(Class<?> instanceClass, Class<?> type) {
        if (instanceClass == null) {
            return null;
        }
        Field contextField = Arrays.stream(instanceClass.getDeclaredFields()).filter(field -> type.isAssignableFrom(field.getType())).findFirst().orElse(null);
        if (contextField == null) {
            return this.getFieldFromTestInstance(instanceClass.getSuperclass(), type);
        }
        contextField.setAccessible(true);
        return contextField;
    }
}

