/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.validation.impl;

import javax.annotation.Nonnull;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.validation.ValidationResult;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"adaptables=org.apache.sling.api.Resource", "adapters=org.apache.sling.validation.ValidationResult"})
public class ResourceToValidationResultAdapterFactory
implements AdapterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceToValidationResultAdapterFactory.class);
    @Nonnull
    private static final String KEY_RESOURCE_METADATA = "sling.validation.result";

    public <AdapterType> AdapterType getAdapter(Object adaptable, Class<AdapterType> type) {
        AdapterType adapter = null;
        if (adaptable instanceof Resource) {
            Resource resource = (Resource)adaptable;
            if (type == ValidationResult.class) {
                return (AdapterType)this.getValidationResultFromCache(resource);
            }
            LOG.warn("Cannot handle adapter {}", (Object)type.getName());
        } else {
            LOG.warn("Cannot handle adaptable {}", (Object)adaptable.getClass().getName());
        }
        return adapter;
    }

    public static void putValidationResultToCache(ValidationResult validationResult, Resource resource) {
        resource.getResourceMetadata().put(KEY_RESOURCE_METADATA, (Object)validationResult);
    }

    private ValidationResult getValidationResultFromCache(Resource resource) {
        return (ValidationResult)resource.getResourceMetadata().get((Object)KEY_RESOURCE_METADATA);
    }
}

