/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDecodingContext;
import org.apache.hadoop.hbase.io.encoding.HFileBlockEncodingContext;
import org.apache.hadoop.hbase.io.hfile.HFileContext;

@InterfaceAudience.Private
public interface DataBlockEncoder {
    public void startBlockEncoding(HFileBlockEncodingContext var1, DataOutputStream var2) throws IOException;

    public int encode(Cell var1, HFileBlockEncodingContext var2, DataOutputStream var3) throws IOException;

    public void endBlockEncoding(HFileBlockEncodingContext var1, DataOutputStream var2, byte[] var3) throws IOException;

    public ByteBuffer decodeKeyValues(DataInputStream var1, HFileBlockDecodingContext var2) throws IOException;

    public ByteBuffer getFirstKeyInBlock(ByteBuffer var1);

    public EncodedSeeker createSeeker(KeyValue.KVComparator var1, HFileBlockDecodingContext var2);

    public HFileBlockEncodingContext newDataBlockEncodingContext(DataBlockEncoding var1, byte[] var2, HFileContext var3);

    public HFileBlockDecodingContext newDataBlockDecodingContext(HFileContext var1);

    public static interface EncodedSeeker {
        public void setCurrentBuffer(ByteBuffer var1);

        public ByteBuffer getKeyDeepCopy();

        public ByteBuffer getValueShallowCopy();

        public ByteBuffer getKeyValueBuffer();

        public Cell getKeyValue();

        public void rewind();

        public boolean next();

        @Deprecated
        public int seekToKeyInBlock(byte[] var1, int var2, int var3, boolean var4);

        public int seekToKeyInBlock(Cell var1, boolean var2);

        public int compareKey(KeyValue.KVComparator var1, byte[] var2, int var3, int var4);

        public int compareKey(KeyValue.KVComparator var1, Cell var2);
    }
}

