/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common;

import java.util.Arrays;
import org.apache.hadoop.hive.common.ValidTxnList;

public class ValidTxnListImpl
implements ValidTxnList {
    private long[] exceptions;
    private long highWatermark;

    public ValidTxnListImpl() {
        this(new long[0], Long.MAX_VALUE);
    }

    public ValidTxnListImpl(long[] exceptions, long highWatermark) {
        if (exceptions.length == 0) {
            this.exceptions = exceptions;
        } else {
            this.exceptions = (long[])exceptions.clone();
            Arrays.sort(this.exceptions);
        }
        this.highWatermark = highWatermark;
    }

    public ValidTxnListImpl(String value) {
        this.readFromString(value);
    }

    @Override
    public boolean isTxnCommitted(long txnid) {
        if (this.highWatermark < txnid) {
            return false;
        }
        return Arrays.binarySearch(this.exceptions, txnid) < 0;
    }

    @Override
    public ValidTxnList.RangeResponse isTxnRangeCommitted(long minTxnId, long maxTxnId) {
        if (this.highWatermark < minTxnId) {
            return ValidTxnList.RangeResponse.NONE;
        }
        if (this.exceptions.length > 0 && this.exceptions[0] > maxTxnId) {
            return ValidTxnList.RangeResponse.ALL;
        }
        long count = Math.max(0L, maxTxnId - this.highWatermark);
        for (long txn : this.exceptions) {
            if (minTxnId > txn || txn > maxTxnId) continue;
            ++count;
        }
        if (count == 0L) {
            return ValidTxnList.RangeResponse.ALL;
        }
        if (count == maxTxnId - minTxnId + 1L) {
            return ValidTxnList.RangeResponse.NONE;
        }
        return ValidTxnList.RangeResponse.SOME;
    }

    public String toString() {
        return this.writeToString();
    }

    @Override
    public String writeToString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.highWatermark);
        if (this.exceptions.length == 0) {
            buf.append(':');
        } else {
            for (long except : this.exceptions) {
                buf.append(':');
                buf.append(except);
            }
        }
        return buf.toString();
    }

    @Override
    public void readFromString(String src) {
        if (src == null) {
            this.highWatermark = Long.MAX_VALUE;
            this.exceptions = new long[0];
        } else {
            String[] values = src.split(":");
            this.highWatermark = Long.parseLong(values[0]);
            this.exceptions = new long[values.length - 1];
            for (int i = 1; i < values.length; ++i) {
                this.exceptions[i - 1] = Long.parseLong(values[i]);
            }
        }
    }

    @Override
    public long getHighWatermark() {
        return this.highWatermark;
    }

    @Override
    public long[] getOpenTransactions() {
        return this.exceptions;
    }
}

