/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.execute;

import java.io.Serializable;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;

public class ExecRowBuilder
implements Serializable {
    private static final long serialVersionUID = -1078823466492523202L;
    private final boolean indexable;
    private final Object[] template;
    private final int[] columns;
    private int count;
    private int maxColumnNumber;

    public ExecRowBuilder(int n, boolean bl) {
        this.template = new Object[n];
        this.columns = new int[n];
        this.indexable = bl;
    }

    public void setColumn(int n, Object object) {
        this.template[this.count] = object;
        this.columns[this.count] = n;
        ++this.count;
        this.maxColumnNumber = Math.max(this.maxColumnNumber, n);
    }

    public ExecRow build(ExecutionFactory executionFactory) throws StandardException {
        ExecRow execRow = this.indexable ? executionFactory.getIndexableRow(this.maxColumnNumber) : executionFactory.getValueRow(this.maxColumnNumber);
        for (int i = 0; i < this.count; ++i) {
            Object object = this.template[i];
            DataValueDescriptor dataValueDescriptor = object instanceof DataValueDescriptor ? ((DataValueDescriptor)object).getNewNull() : ((DataTypeDescriptor)object).getNull();
            execRow.setColumn(this.columns[i], dataValueDescriptor);
        }
        return execRow;
    }

    public void reset(ExecRow execRow) throws StandardException {
        for (int i = 0; i < this.count; ++i) {
            int n = this.columns[i];
            execRow.setColumn(n, execRow.getColumn(n).getNewNull());
        }
    }
}

