/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc.authentication;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Dictionary;
import java.util.Properties;
import org.apache.derby.authentication.UserAuthenticator;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.AuthenticationService;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyFactory;
import org.apache.derby.iapi.services.property.PropertySetCallback;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PasswordHasher;
import org.apache.derby.iapi.sql.dictionary.UserDescriptor;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.util.StringUtil;

public abstract class AuthenticationServiceBase
implements AuthenticationService,
ModuleControl,
ModuleSupportable,
PropertySetCallback {
    protected UserAuthenticator authenticationScheme;
    private AccessFactory store;
    public static final String AuthenticationTrace = null;
    protected static final int SECMEC_USRSSBPWD = 8;

    protected void setAuthenticationService(UserAuthenticator userAuthenticator) {
        this.authenticationScheme = userAuthenticator;
    }

    public void boot(boolean bl, Properties properties) throws StandardException {
        this.store = (AccessFactory)Monitor.getServiceModule(this, "org.apache.derby.iapi.store.access.AccessFactory");
        PropertyFactory propertyFactory = (PropertyFactory)Monitor.getServiceModule(this, "org.apache.derby.iapi.services.property.PropertyFactory");
        if (propertyFactory != null) {
            propertyFactory.addPropertySetNotification(this);
        }
    }

    public void stop() {
    }

    public boolean authenticate(String string, Properties properties) throws SQLException {
        if (properties == (Properties)null) {
            return false;
        }
        String string2 = properties.getProperty("user");
        if (string2 != null && string2.length() > 128) {
            return false;
        }
        return this.authenticationScheme.authenticateUser(string2, properties.getProperty("password"), string, properties);
    }

    public String getSystemCredentialsDatabaseName() {
        return null;
    }

    public String getProperty(String string) {
        String string2 = null;
        TransactionController transactionController = null;
        try {
            transactionController = this.getTransaction();
            string2 = PropertyUtil.getServiceProperty(transactionController, string, null);
            if (transactionController != null) {
                transactionController.commit();
                transactionController = null;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        return string2;
    }

    protected TransactionController getTransaction() throws StandardException {
        if (this.store == null) {
            return null;
        }
        return this.store.getTransaction(ContextService.getFactory().getCurrentContextManager());
    }

    Properties getDatabaseProperties() throws StandardException {
        Properties properties = null;
        TransactionController transactionController = this.getTransaction();
        if (transactionController != null) {
            try {
                properties = transactionController.getProperties();
            }
            finally {
                transactionController.commit();
            }
        }
        return properties;
    }

    protected String getServiceName() {
        if (this.store == null) {
            return null;
        }
        return Monitor.getServiceName(this.store);
    }

    public String getDatabaseProperty(String string) {
        String string2 = null;
        TransactionController transactionController = null;
        try {
            if (this.store != null) {
                transactionController = this.store.getTransaction(ContextService.getFactory().getCurrentContextManager());
            }
            string2 = PropertyUtil.getDatabaseProperty(transactionController, string);
            if (transactionController != null) {
                transactionController.commit();
                transactionController = null;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        return string2;
    }

    public String getSystemProperty(String string) {
        boolean bl = false;
        bl = Boolean.valueOf(this.getDatabaseProperty("derby.database.propertiesOnly"));
        if (bl) {
            return null;
        }
        return PropertyUtil.getSystemProperty(string);
    }

    public void init(boolean bl, Dictionary dictionary) {
    }

    public boolean validate(String string, Serializable serializable, Dictionary dictionary) throws StandardException {
        if (string.startsWith("derby.user.")) {
            return true;
        }
        String string2 = (String)((Object)serializable);
        boolean bl = "NATIVE::LOCAL".equals(string2);
        if ("derby.authentication.provider".equals(string)) {
            String string3;
            DataDictionary dataDictionary;
            UserDescriptor userDescriptor;
            if (string2 != null && string2.startsWith("NATIVE:") && !bl) {
                throw StandardException.newException("XCY05.S.3");
            }
            String string4 = (String)dictionary.get("derby.authentication.provider");
            if (string4 != null && string4.startsWith("NATIVE:")) {
                throw StandardException.newException("XCY05.S.2");
            }
            if (bl && (userDescriptor = (dataDictionary = AuthenticationServiceBase.getDataDictionary()).getUser(string3 = dataDictionary.getAuthorizationDatabaseOwner())) == null) {
                throw StandardException.newException("XCY05.S.3");
            }
        }
        if ("derby.authentication.native.passwordLifetimeMillis".equals(string) && this.parsePasswordLifetime(string2) == null) {
            throw StandardException.newException("4251J", "derby.authentication.native.passwordLifetimeMillis");
        }
        if ("derby.authentication.native.passwordLifetimeThreshold".equals(string) && this.parsePasswordThreshold(string2) == null) {
            throw StandardException.newException("4251J", "derby.authentication.native.passwordLifetimeThreshold");
        }
        return false;
    }

    protected Long parsePasswordLifetime(String string) {
        try {
            long l = Long.parseLong(string);
            if (l < 0L) {
                l = 0L;
            }
            return new Long(l);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected Double parsePasswordThreshold(String string) {
        try {
            double d = Double.parseDouble(string);
            if (d <= 0.0) {
                return null;
            }
            return new Double(d);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Serviceable apply(String string, Serializable serializable, Dictionary dictionary) {
        return null;
    }

    public Serializable map(String string, Serializable serializable, Dictionary dictionary) throws StandardException {
        if (!string.startsWith("derby.user.")) {
            return null;
        }
        String string2 = (String)dictionary.get("derby.authentication.provider");
        if (string2 != null && StringUtil.SQLEqualsIgnoreCase(string2, "LDAP")) {
            return null;
        }
        String string3 = (String)((Object)serializable);
        if (string3 != null) {
            String string4 = string.substring("derby.user.".length());
            string3 = this.hashUsingDefaultAlgorithm(string4, string3, dictionary);
        }
        return string3;
    }

    protected final boolean requireAuthentication(Properties properties) {
        String string = PropertyUtil.getPropertyFromSet(properties, "derby.connection.requireAuthentication");
        if (Boolean.valueOf(string).booleanValue()) {
            return true;
        }
        return PropertyUtil.nativeAuthenticationEnabled(properties);
    }

    protected String hashPasswordSHA1Scheme(String string) {
        if (string == null) {
            return null;
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        messageDigest.reset();
        byte[] byArray = null;
        byArray = AuthenticationServiceBase.toHexByte(string);
        messageDigest.update(byArray);
        byte[] byArray2 = messageDigest.digest();
        String string2 = "3b60" + StringUtil.toHexString(byArray2, 0, byArray2.length);
        return string2;
    }

    private static byte[] toHexByte(String string) {
        byte[] byArray = new byte[string.length() * 2];
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            int n = (c & 0xF0) >>> 4;
            int n2 = c & 0xF;
            byArray[i] = (byte)n;
            byArray[i + 1] = (byte)n2;
        }
        return byArray;
    }

    String hashUsingDefaultAlgorithm(String string, String string2, Dictionary dictionary) throws StandardException {
        if (string2 == null) {
            return null;
        }
        PasswordHasher passwordHasher = AuthenticationServiceBase.getDataDictionary().makePasswordHasher(dictionary);
        if (passwordHasher != null) {
            return passwordHasher.hashAndEncode(string, string2);
        }
        return this.hashPasswordSHA1Scheme(string2);
    }

    private static DataDictionary getDataDictionary() {
        LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)ContextService.getContext("LanguageConnectionContext");
        return languageConnectionContext.getDataDictionary();
    }

    protected String substitutePassword(String string, String string2, Properties properties, boolean bl) {
        byte[] byArray;
        MessageDigest messageDigest = null;
        byte[] byArray2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 1};
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        messageDigest.reset();
        byte[] byArray3 = null;
        byte[] byArray4 = AuthenticationServiceBase.toHexByte(string);
        String string3 = properties.getProperty("drdaSecTokenIn");
        String string4 = properties.getProperty("drdaSecTokenOut");
        byte[] byArray5 = StringUtil.fromHexString(string3, 0, string3.length());
        byte[] byArray6 = StringUtil.fromHexString(string4, 0, string4.length());
        String string5 = null;
        if (!bl) {
            byArray3 = AuthenticationServiceBase.toHexByte(string2);
            messageDigest.update(byArray3);
            byArray = messageDigest.digest();
            string5 = "3b60" + StringUtil.toHexString(byArray, 0, byArray.length);
        } else {
            string5 = string2;
        }
        messageDigest.update(byArray4);
        messageDigest.update(AuthenticationServiceBase.toHexByte(string5));
        byArray = messageDigest.digest();
        messageDigest.update(byArray);
        messageDigest.update(byArray6);
        messageDigest.update(byArray5);
        messageDigest.update(byArray4);
        messageDigest.update(byArray2);
        byte[] byArray7 = messageDigest.digest();
        return StringUtil.toHexString(byArray7, 0, byArray7.length);
    }
}

