/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy.objectinspector;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.hive.serde2.avro.AvroLazyObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyListObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyMapObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazySimpleStructObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyUnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.io.Text;

public final class LazyObjectInspectorFactory {
    static ConcurrentHashMap<ArrayList<Object>, LazySimpleStructObjectInspector> cachedLazySimpleStructObjectInspector = new ConcurrentHashMap();
    static ConcurrentHashMap<ArrayList<Object>, LazyListObjectInspector> cachedLazySimpleListObjectInspector = new ConcurrentHashMap();
    static ConcurrentHashMap<ArrayList<Object>, LazyMapObjectInspector> cachedLazySimpleMapObjectInspector = new ConcurrentHashMap();
    static ConcurrentHashMap<List<Object>, LazyUnionObjectInspector> cachedLazyUnionObjectInspector = new ConcurrentHashMap();

    public static LazySimpleStructObjectInspector getLazySimpleStructObjectInspector(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors, byte separator, Text nullSequence, boolean lastColumnTakesRest, boolean escaped, byte escapeChar) {
        return LazyObjectInspectorFactory.getLazySimpleStructObjectInspector(structFieldNames, structFieldObjectInspectors, null, separator, nullSequence, lastColumnTakesRest, escaped, escapeChar, ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
    }

    public static LazySimpleStructObjectInspector getLazySimpleStructObjectInspector(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors, byte separator, Text nullSequence, boolean lastColumnTakesRest, boolean escaped, byte escapeChar, ObjectInspectorFactory.ObjectInspectorOptions option) {
        return LazyObjectInspectorFactory.getLazySimpleStructObjectInspector(structFieldNames, structFieldObjectInspectors, null, separator, nullSequence, lastColumnTakesRest, escaped, escapeChar, option);
    }

    public static LazySimpleStructObjectInspector getLazySimpleStructObjectInspector(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors, List<String> structFieldComments, byte separator, Text nullSequence, boolean lastColumnTakesRest, boolean escaped, byte escapeChar) {
        return LazyObjectInspectorFactory.getLazySimpleStructObjectInspector(structFieldNames, structFieldObjectInspectors, structFieldComments, separator, nullSequence, lastColumnTakesRest, escaped, escapeChar, ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
    }

    public static LazySimpleStructObjectInspector getLazySimpleStructObjectInspector(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors, List<String> structFieldComments, byte separator, Text nullSequence, boolean lastColumnTakesRest, boolean escaped, byte escapeChar, ObjectInspectorFactory.ObjectInspectorOptions option) {
        LazySimpleStructObjectInspector result;
        ArrayList<Object> signature = new ArrayList<Object>();
        signature.add(structFieldNames);
        signature.add(structFieldObjectInspectors);
        signature.add(separator);
        signature.add(nullSequence.toString());
        signature.add(lastColumnTakesRest);
        signature.add(escaped);
        signature.add(escapeChar);
        signature.add((Object)option);
        if (structFieldComments != null) {
            signature.add(structFieldComments);
        }
        if ((result = cachedLazySimpleStructObjectInspector.get(signature)) == null) {
            switch (option) {
                case JAVA: {
                    result = new LazySimpleStructObjectInspector(structFieldNames, structFieldObjectInspectors, structFieldComments, separator, nullSequence, lastColumnTakesRest, escaped, escapeChar);
                    break;
                }
                case AVRO: {
                    result = new AvroLazyObjectInspector(structFieldNames, structFieldObjectInspectors, structFieldComments, separator, nullSequence, lastColumnTakesRest, escaped, escapeChar);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal ObjectInspector type [" + (Object)((Object)option) + "]");
                }
            }
            cachedLazySimpleStructObjectInspector.put(signature, result);
        }
        return result;
    }

    public static LazyListObjectInspector getLazySimpleListObjectInspector(ObjectInspector listElementObjectInspector, byte separator, Text nullSequence, boolean escaped, byte escapeChar) {
        ArrayList<Object> signature = new ArrayList<Object>();
        signature.add(listElementObjectInspector);
        signature.add(separator);
        signature.add(nullSequence.toString());
        signature.add(escaped);
        signature.add(escapeChar);
        LazyListObjectInspector result = cachedLazySimpleListObjectInspector.get(signature);
        if (result == null) {
            result = new LazyListObjectInspector(listElementObjectInspector, separator, nullSequence, escaped, escapeChar);
            cachedLazySimpleListObjectInspector.put(signature, result);
        }
        return result;
    }

    public static LazyMapObjectInspector getLazySimpleMapObjectInspector(ObjectInspector mapKeyObjectInspector, ObjectInspector mapValueObjectInspector, byte itemSeparator, byte keyValueSeparator, Text nullSequence, boolean escaped, byte escapeChar) {
        ArrayList<Object> signature = new ArrayList<Object>();
        signature.add(mapKeyObjectInspector);
        signature.add(mapValueObjectInspector);
        signature.add(itemSeparator);
        signature.add(keyValueSeparator);
        signature.add(nullSequence.toString());
        signature.add(escaped);
        signature.add(escapeChar);
        LazyMapObjectInspector result = cachedLazySimpleMapObjectInspector.get(signature);
        if (result == null) {
            result = new LazyMapObjectInspector(mapKeyObjectInspector, mapValueObjectInspector, itemSeparator, keyValueSeparator, nullSequence, escaped, escapeChar);
            cachedLazySimpleMapObjectInspector.put(signature, result);
        }
        return result;
    }

    public static LazyUnionObjectInspector getLazyUnionObjectInspector(List<ObjectInspector> ois, byte separator, Text nullSequence, boolean escaped, byte escapeChar) {
        ArrayList<Object> signature = new ArrayList<Object>();
        signature.add(ois);
        signature.add(separator);
        signature.add(nullSequence.toString());
        signature.add(escaped);
        signature.add(escapeChar);
        LazyUnionObjectInspector result = cachedLazyUnionObjectInspector.get(signature);
        if (result == null) {
            result = new LazyUnionObjectInspector(ois, separator, nullSequence, escaped, escapeChar);
            cachedLazyUnionObjectInspector.put(signature, result);
        }
        return result;
    }

    private LazyObjectInspectorFactory() {
    }
}

