/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.session;

import java.io.IOException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.session.HiveSession;
import org.apache.hive.service.cli.session.HiveSessionImpl;
import org.apache.hive.service.cli.thrift.TProtocolVersion;

public class HiveSessionImplwithUGI
extends HiveSessionImpl {
    public static final String HS2TOKEN = "HiveServer2ImpersonationToken";
    private UserGroupInformation sessionUgi = null;
    private String delegationTokenStr = null;
    private Hive sessionHive = null;
    private HiveSession proxySession = null;

    public HiveSessionImplwithUGI(TProtocolVersion protocol, String username, String password, HiveConf hiveConf, String ipAddress, String delegationToken) throws HiveSQLException {
        super(protocol, username, password, hiveConf, ipAddress);
        this.setSessionUGI(username);
        this.setDelegationToken(delegationToken);
        Hive.set(null);
        try {
            this.sessionHive = Hive.get((HiveConf)this.getHiveConf());
        }
        catch (HiveException e) {
            throw new HiveSQLException("Failed to setup metastore connection", e);
        }
    }

    public void setSessionUGI(String owner) throws HiveSQLException {
        if (owner == null) {
            throw new HiveSQLException("No username provided for impersonation");
        }
        if (ShimLoader.getHadoopShims().isSecurityEnabled()) {
            try {
                this.sessionUgi = ShimLoader.getHadoopShims().createProxyUser(owner);
            }
            catch (IOException e) {
                throw new HiveSQLException("Couldn't setup proxy user", e);
            }
        } else {
            this.sessionUgi = ShimLoader.getHadoopShims().createRemoteUser(owner, null);
        }
    }

    public UserGroupInformation getSessionUgi() {
        return this.sessionUgi;
    }

    public String getDelegationToken() {
        return this.delegationTokenStr;
    }

    @Override
    protected synchronized void acquire(boolean userAccess) {
        super.acquire(userAccess);
        if (this.sessionHive != null) {
            Hive.set((Hive)this.sessionHive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws HiveSQLException {
        try {
            this.acquire(true);
            ShimLoader.getHadoopShims().closeAllForUGI(this.sessionUgi);
            this.cancelDelegationToken();
        }
        finally {
            this.release(true);
            super.close();
        }
    }

    private void setDelegationToken(String delegationTokenStr) throws HiveSQLException {
        this.delegationTokenStr = delegationTokenStr;
        if (delegationTokenStr != null) {
            this.getHiveConf().set("hive.metastore.token.signature", HS2TOKEN);
            try {
                ShimLoader.getHadoopShims().setTokenStr(this.sessionUgi, delegationTokenStr, HS2TOKEN);
            }
            catch (IOException e) {
                throw new HiveSQLException("Couldn't setup delegation token in the ugi", e);
            }
        }
    }

    private void cancelDelegationToken() throws HiveSQLException {
        if (this.delegationTokenStr != null) {
            try {
                Hive.get((HiveConf)this.getHiveConf()).cancelDelegationToken(this.delegationTokenStr);
            }
            catch (HiveException e) {
                throw new HiveSQLException("Couldn't cancel delegation token", e);
            }
            Hive.closeCurrent();
        }
    }

    @Override
    protected HiveSession getSession() {
        assert (this.proxySession != null);
        return this.proxySession;
    }

    public void setProxySession(HiveSession proxySession) {
        this.proxySession = proxySession;
    }

    @Override
    public String getDelegationToken(HiveAuthFactory authFactory, String owner, String renewer) throws HiveSQLException {
        return authFactory.getDelegationToken(owner, renewer);
    }

    @Override
    public void cancelDelegationToken(HiveAuthFactory authFactory, String tokenStr) throws HiveSQLException {
        authFactory.cancelDelegationToken(tokenStr);
    }

    @Override
    public void renewDelegationToken(HiveAuthFactory authFactory, String tokenStr) throws HiveSQLException {
        authFactory.renewDelegationToken(tokenStr);
    }
}

