/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.sql.runtime.trident.functions;

import java.util.Collections;
import java.util.Map;
import org.apache.calcite.DataContext;
import org.apache.calcite.interpreter.StormContext;
import org.apache.storm.sql.runtime.calcite.DebuggableExecutableExpression;
import org.apache.storm.sql.runtime.calcite.ExecutableExpression;
import org.apache.storm.trident.operation.OperationAwareFlatMapFunction;
import org.apache.storm.trident.operation.TridentOperationContext;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.tuple.Values;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvaluationCalc
implements OperationAwareFlatMapFunction {
    private static final Logger LOG = LoggerFactory.getLogger(EvaluationCalc.class);
    private final ExecutableExpression filterInstance;
    private final ExecutableExpression projectionInstance;
    private final Object[] outputValues;
    private final DataContext dataContext;

    public EvaluationCalc(ExecutableExpression filterInstance, ExecutableExpression projectionInstance, int outputCount, DataContext dataContext) {
        this.filterInstance = filterInstance;
        this.projectionInstance = projectionInstance;
        this.outputValues = new Object[outputCount];
        this.dataContext = dataContext;
    }

    public void prepare(Map conf, TridentOperationContext context) {
        if (this.projectionInstance != null && this.projectionInstance instanceof DebuggableExecutableExpression) {
            LOG.info("Expression code for projection: \n{}", (Object)((DebuggableExecutableExpression)this.projectionInstance).getDelegateCode());
        }
        if (this.filterInstance != null && this.filterInstance instanceof DebuggableExecutableExpression) {
            LOG.info("Expression code for filter: \n{}", (Object)((DebuggableExecutableExpression)this.filterInstance).getDelegateCode());
        }
    }

    public void cleanup() {
    }

    public Iterable<Values> execute(TridentTuple input) {
        StormContext calciteContext = new StormContext(this.dataContext);
        calciteContext.values = input.getValues().toArray();
        if (this.filterInstance != null) {
            this.filterInstance.execute(calciteContext, this.outputValues);
            if (this.outputValues[0] == null || !((Boolean)this.outputValues[0]).booleanValue()) {
                return Collections.emptyList();
            }
        }
        if (this.projectionInstance != null) {
            this.projectionInstance.execute(calciteContext, this.outputValues);
            return Collections.singletonList(new Values(this.outputValues));
        }
        return Collections.singletonList(new Values(new Object[]{input.getValues()}));
    }
}

