/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.executor.bolt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.BooleanSupplier;
import org.apache.storm.Constants;
import org.apache.storm.ICredentialsListener;
import org.apache.storm.daemon.Task;
import org.apache.storm.daemon.metrics.BuiltinMetricsUtil;
import org.apache.storm.daemon.worker.WorkerState;
import org.apache.storm.executor.Executor;
import org.apache.storm.executor.bolt.BoltOutputCollectorImpl;
import org.apache.storm.hooks.info.BoltExecuteInfo;
import org.apache.storm.metric.api.IMetricsRegistrant;
import org.apache.storm.policy.IWaitStrategy;
import org.apache.storm.policy.WaitStrategyPark;
import org.apache.storm.security.auth.IAutoCredentials;
import org.apache.storm.stats.BoltExecutorStats;
import org.apache.storm.task.IBolt;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.tuple.AddressedTuple;
import org.apache.storm.tuple.TupleImpl;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.JCQueue;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ReflectionUtils;
import org.apache.storm.utils.Time;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BoltExecutor
extends Executor {
    private static final Logger LOG = LoggerFactory.getLogger(BoltExecutor.class);
    private final BooleanSupplier executeSampler;
    private final boolean isSystemBoltExecutor;
    private final IWaitStrategy consumeWaitStrategy;
    private final IWaitStrategy backPressureWaitStrategy;
    private final BoltExecutorStats stats;
    private BoltOutputCollectorImpl outputCollector;

    public BoltExecutor(WorkerState workerData, List<Long> executorId, Map<String, String> credentials) {
        super(workerData, executorId, credentials, "bolt");
        this.executeSampler = ConfigUtils.mkStatsSampler(this.topoConf);
        boolean bl = this.isSystemBoltExecutor = executorId == Constants.SYSTEM_EXECUTOR_ID;
        if (this.isSystemBoltExecutor) {
            this.consumeWaitStrategy = BoltExecutor.makeSystemBoltWaitStrategy();
        } else {
            this.consumeWaitStrategy = (IWaitStrategy)ReflectionUtils.newInstance((String)this.topoConf.get("topology.bolt.wait.strategy"));
            this.consumeWaitStrategy.prepare(this.topoConf, IWaitStrategy.WaitSituation.BOLT_WAIT);
        }
        this.backPressureWaitStrategy = (IWaitStrategy)ReflectionUtils.newInstance((String)this.topoConf.get("topology.backpressure.wait.strategy"));
        this.backPressureWaitStrategy.prepare(this.topoConf, IWaitStrategy.WaitSituation.BACK_PRESSURE_WAIT);
        this.stats = new BoltExecutorStats(ConfigUtils.samplingRate(this.getTopoConf()), ObjectReader.getInt(this.getTopoConf().get("num.stat.buckets")));
    }

    private static IWaitStrategy makeSystemBoltWaitStrategy() {
        WaitStrategyPark ws = new WaitStrategyPark();
        HashMap<String, Object> conf = new HashMap<String, Object>();
        conf.put("topology.bolt.wait.park.microsec", 5000);
        ws.prepare(conf, IWaitStrategy.WaitSituation.BOLT_WAIT);
        return ws;
    }

    @Override
    public BoltExecutorStats getStats() {
        return this.stats;
    }

    public void init(ArrayList<Task> idToTask, int idToTaskBase) throws InterruptedException {
        this.executorTransfer.initLocalRecvQueues();
        this.workerReady.await();
        while (!this.stormActive.get()) {
            Utils.sleepNoSimulation(100L);
        }
        LOG.info("Preparing bolt {}:{}", (Object)this.componentId, this.getTaskIds());
        for (Task taskData : idToTask) {
            if (taskData == null) continue;
            IBolt boltObject = (IBolt)taskData.getTaskObject();
            TopologyContext userContext = taskData.getUserContext();
            if (boltObject instanceof ICredentialsListener) {
                ((ICredentialsListener)((Object)boltObject)).setCredentials(this.credentials);
            }
            if ("__system".equals(this.componentId)) {
                BuiltinMetricsUtil.registerIconnectionServerMetric(this.workerData.getReceiver(), this.topoConf, userContext);
                if (this.workerData.getAutoCredentials() != null) {
                    for (IAutoCredentials autoCredential : this.workerData.getAutoCredentials()) {
                        if (!(autoCredential instanceof IMetricsRegistrant)) continue;
                        IMetricsRegistrant registrant = (IMetricsRegistrant)((Object)autoCredential);
                        registrant.registerMetrics(userContext, this.topoConf);
                    }
                }
            }
            this.outputCollector = new BoltOutputCollectorImpl(this, taskData, this.rand, this.hasEventLoggers, this.ackingEnabled, this.isDebug);
            boltObject.prepare(this.topoConf, userContext, new OutputCollector(this.outputCollector));
        }
        this.openOrPrepareWasCalled.set(true);
        LOG.info("Prepared bolt {}:{}", (Object)this.componentId, (Object)this.taskIds);
        this.setupTicks(false);
        this.setupMetrics();
    }

    public Callable<Long> call() throws Exception {
        this.init(this.idToTask, this.idToTaskBase);
        return new Callable<Long>(){
            int bpIdleCount = 0;
            int consumeIdleCounter = 0;
            private final JCQueue.ExitCondition tillNoPendingEmits = () -> BoltExecutor.this.pendingEmits.isEmpty();

            @Override
            public Long call() throws Exception {
                BoltExecutor.this.updateExecCredsIfRequired();
                boolean pendingEmitsIsEmpty = this.tryFlushPendingEmits();
                if (pendingEmitsIsEmpty) {
                    if (this.bpIdleCount != 0) {
                        LOG.debug("Ending Back Pressure Wait stretch : {}", (Object)this.bpIdleCount);
                    }
                    this.bpIdleCount = 0;
                    int consumeCount = BoltExecutor.this.receiveQueue.consume(BoltExecutor.this, this.tillNoPendingEmits);
                    if (consumeCount == 0) {
                        if (this.consumeIdleCounter == 0) {
                            LOG.debug("Invoking consume wait strategy");
                        }
                        this.consumeIdleCounter = BoltExecutor.this.consumeWaitStrategy.idle(this.consumeIdleCounter);
                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                    } else {
                        if (this.consumeIdleCounter != 0) {
                            LOG.debug("Ending consume wait stretch : {}", (Object)this.consumeIdleCounter);
                        }
                        this.consumeIdleCounter = 0;
                    }
                } else {
                    if (this.bpIdleCount == 0) {
                        LOG.debug("Experiencing Back Pressure. Entering BackPressure Wait. PendingEmits = {}", (Object)BoltExecutor.this.pendingEmits.size());
                    }
                    this.bpIdleCount = BoltExecutor.this.backPressureWaitStrategy.idle(this.bpIdleCount);
                }
                return 0L;
            }

            private boolean tryFlushPendingEmits() {
                AddressedTuple t = (AddressedTuple)BoltExecutor.this.pendingEmits.peek();
                while (t != null) {
                    if (!BoltExecutor.this.executorTransfer.tryTransfer(t, null)) {
                        return false;
                    }
                    BoltExecutor.this.pendingEmits.poll();
                    t = (AddressedTuple)BoltExecutor.this.pendingEmits.peek();
                }
                return true;
            }
        };
    }

    @Override
    public void tupleActionFn(int taskId, TupleImpl tuple) throws Exception {
        String streamId = tuple.getSourceStreamId();
        if ("__flush".equals(streamId)) {
            this.outputCollector.flush();
        } else if ("__metrics_tick".equals(streamId)) {
            this.metricsTick((Task)this.idToTask.get(taskId - this.idToTaskBase), tuple);
        } else {
            TopologyContext topologyContext;
            long delta;
            Long now;
            IBolt boltObject = (IBolt)((Task)this.idToTask.get(taskId - this.idToTaskBase)).getTaskObject();
            boolean isSampled = this.sampler.getAsBoolean();
            boolean isExecuteSampler = this.executeSampler.getAsBoolean();
            Long l = now = isSampled || isExecuteSampler ? Long.valueOf(Time.currentTimeMillis()) : null;
            if (isSampled) {
                tuple.setProcessSampleStartTime(now);
            }
            if (isExecuteSampler) {
                tuple.setExecuteSampleStartTime(now);
            }
            boltObject.execute(tuple);
            Long ms = tuple.getExecuteSampleStartTime();
            long l2 = delta = ms != null ? Time.deltaMs(ms) : -1L;
            if (this.isDebug.booleanValue()) {
                LOG.info("Execute done TUPLE {} TASK: {} DELTA: {}", new Object[]{tuple, taskId, delta});
            }
            if (!(topologyContext = ((Task)this.idToTask.get(taskId - this.idToTaskBase)).getUserContext()).getHooks().isEmpty()) {
                new BoltExecuteInfo(tuple, taskId, delta).applyOn(topologyContext);
            }
            if (delta >= 0L) {
                Task firstTask = (Task)this.idToTask.get((Integer)this.taskIds.get(0) - this.idToTaskBase);
                this.stats.boltExecuteTuple(tuple.getSourceComponent(), tuple.getSourceStreamId(), delta, this.workerData.getUptime().upTime(), firstTask);
                Task currentTask = (Task)this.idToTask.get(taskId - this.idToTaskBase);
                currentTask.getTaskMetrics().boltExecuteTuple(tuple.getSourceComponent(), tuple.getSourceStreamId(), delta);
            }
        }
    }
}

