/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metric;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.storm.metric.IEventLogger;
import org.apache.storm.shade.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.utils.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileBasedEventLogger
implements IEventLogger {
    private static final Logger LOG = LoggerFactory.getLogger(FileBasedEventLogger.class);
    private static final int FLUSH_INTERVAL_MILLIS = 1000;
    private Path eventLogPath;
    private BufferedWriter eventLogWriter;
    private ScheduledExecutorService flushScheduler;
    private volatile boolean dirty = false;

    private void initLogWriter(Path logFilePath) {
        try {
            LOG.info("logFilePath {}", (Object)logFilePath);
            this.eventLogPath = logFilePath;
            this.eventLogWriter = Files.newBufferedWriter(this.eventLogPath, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            LOG.error("Error setting up FileBasedEventLogger.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void setUpFlushTask() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("event-logger-flush-%d").setDaemon(true).build();
        this.flushScheduler = Executors.newSingleThreadScheduledExecutor(threadFactory);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (FileBasedEventLogger.this.dirty) {
                        FileBasedEventLogger.this.eventLogWriter.flush();
                        FileBasedEventLogger.this.dirty = false;
                    }
                }
                catch (IOException ex) {
                    LOG.error("Error flushing " + String.valueOf(FileBasedEventLogger.this.eventLogPath), (Throwable)ex);
                    throw new RuntimeException(ex);
                }
            }
        };
        this.flushScheduler.scheduleAtFixedRate(runnable, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void prepare(Map<String, Object> conf, Map<String, Object> arguments, TopologyContext context) {
        String stormId = context.getStormId();
        int port = context.getThisWorkerPort();
        String workersArtifactRoot = ConfigUtils.workerArtifactsRoot(conf, stormId, port);
        Path path = Paths.get(workersArtifactRoot, "events.log");
        File dir = path.toFile().getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.initLogWriter(path);
        this.setUpFlushTask();
    }

    @Override
    public void log(IEventLogger.EventInfo event) {
        try {
            this.eventLogWriter.write(this.buildLogMessage(event));
            this.eventLogWriter.newLine();
            this.dirty = true;
        }
        catch (IOException ex) {
            LOG.error("Error logging event {}", (Object)event, (Object)ex);
            throw new RuntimeException(ex);
        }
    }

    protected String buildLogMessage(IEventLogger.EventInfo event) {
        return event.toString();
    }

    @Override
    public void close() {
        try {
            this.eventLogWriter.close();
        }
        catch (IOException ex) {
            LOG.error("Error closing event log.", (Throwable)ex);
        }
        this.closeFlushScheduler();
    }

    private void closeFlushScheduler() {
        if (this.flushScheduler != null) {
            this.flushScheduler.shutdown();
            try {
                if (!this.flushScheduler.awaitTermination(2L, TimeUnit.SECONDS)) {
                    this.flushScheduler.shutdownNow();
                }
            }
            catch (InterruptedException ie) {
                this.flushScheduler.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }
}

