/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.streams.processors;

import org.apache.storm.streams.operations.CombinerAggregator;
import org.apache.storm.streams.processors.BaseProcessor;
import org.apache.storm.streams.processors.BatchProcessor;

public class MergeAggregateProcessor<T, A, R>
extends BaseProcessor<A>
implements BatchProcessor {
    private final CombinerAggregator<T, A, R> aggregator;
    private A state;

    public MergeAggregateProcessor(CombinerAggregator<T, A, R> aggregator) {
        this.aggregator = aggregator;
    }

    @Override
    protected void execute(A input) {
        if (this.state == null) {
            this.state = this.aggregator.init();
        }
        this.state = this.aggregator.merge(this.state, input);
        this.mayBeForwardAggUpdate(() -> this.aggregator.result(this.state));
    }

    @Override
    public void finish() {
        if (this.state != null) {
            this.context.forward(this.aggregator.result(this.state));
            this.state = null;
        }
    }
}

