/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.state.map;

import java.util.Arrays;
import java.util.List;
import org.apache.storm.trident.state.ValueUpdater;
import org.apache.storm.trident.state.map.MapState;
import org.apache.storm.trident.state.snapshot.Snapshottable;

public class SnapshottableMap<T>
implements MapState<T>,
Snapshottable<T> {
    MapState<T> delegate;
    List<List<Object>> keys;

    public SnapshottableMap(MapState<T> delegate, List<Object> snapshotKey) {
        this.delegate = delegate;
        this.keys = Arrays.asList(snapshotKey);
    }

    @Override
    public List<T> multiGet(List<List<Object>> keys) {
        return this.delegate.multiGet(keys);
    }

    @Override
    public List<T> multiUpdate(List<List<Object>> keys, List<ValueUpdater> updaters) {
        return this.delegate.multiUpdate(keys, updaters);
    }

    @Override
    public void multiPut(List<List<Object>> keys, List<T> vals) {
        this.delegate.multiPut(keys, vals);
    }

    @Override
    public void beginCommit(Long txid) {
        this.delegate.beginCommit(txid);
    }

    @Override
    public void commit(Long txid) {
        this.delegate.commit(txid);
    }

    @Override
    public T get() {
        return this.multiGet(this.keys).get(0);
    }

    @Override
    public T update(ValueUpdater updater) {
        List<ValueUpdater> updaters = Arrays.asList(updater);
        return this.multiUpdate(this.keys, updaters).get(0);
    }

    @Override
    public void set(T o) {
        this.multiPut(this.keys, Arrays.asList(o));
    }
}

