/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.tuple;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.trident.tuple.ValuePointer;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;

public class TridentTupleView
extends AbstractList<Object>
implements TridentTuple {
    public static final TridentTupleView EMPTY_TUPLE = new TridentTupleView(null, new ValuePointer[0], new HashMap<String, ValuePointer>());
    private final ValuePointer[] index;
    private final Map<String, ValuePointer> fieldIndex;
    private final List<List<Object>> delegates;

    public TridentTupleView(List delegates, ValuePointer[] index, Map<String, ValuePointer> fieldIndex) {
        this.delegates = delegates;
        this.index = index;
        this.fieldIndex = fieldIndex;
    }

    private static List<String> indexToFieldsList(ValuePointer[] index) {
        ArrayList<String> ret = new ArrayList<String>();
        for (ValuePointer p : index) {
            ret.add(p.field);
        }
        return ret;
    }

    public static TridentTuple createFreshTuple(Fields fields, List<Object> values) {
        FreshOutputFactory factory = new FreshOutputFactory(fields);
        return factory.create(values);
    }

    public static TridentTuple createFreshTuple(Fields fields, Object ... values) {
        FreshOutputFactory factory = new FreshOutputFactory(fields);
        return factory.create(Arrays.asList(values));
    }

    @Override
    public List<Object> getValues() {
        return this;
    }

    @Override
    public int size() {
        return this.index.length;
    }

    @Override
    public boolean contains(String field) {
        return this.getFields().contains(field);
    }

    @Override
    public Fields getFields() {
        return new Fields(TridentTupleView.indexToFieldsList(this.index));
    }

    @Override
    public int fieldIndex(String field) {
        return this.getFields().fieldIndex(field);
    }

    @Override
    public List<Object> select(Fields selector) {
        return this.getFields().select(selector, this.getValues());
    }

    @Override
    public Object get(int i) {
        return this.getValue(i);
    }

    @Override
    public Object getValue(int i) {
        return this.getValueByPointer(this.index[i]);
    }

    @Override
    public String getString(int i) {
        return (String)this.getValue(i);
    }

    @Override
    public Integer getInteger(int i) {
        return (Integer)this.getValue(i);
    }

    @Override
    public Long getLong(int i) {
        return (Long)this.getValue(i);
    }

    @Override
    public Boolean getBoolean(int i) {
        return (Boolean)this.getValue(i);
    }

    @Override
    public Short getShort(int i) {
        return (Short)this.getValue(i);
    }

    @Override
    public Byte getByte(int i) {
        return (Byte)this.getValue(i);
    }

    @Override
    public Double getDouble(int i) {
        return (Double)this.getValue(i);
    }

    @Override
    public Float getFloat(int i) {
        return (Float)this.getValue(i);
    }

    @Override
    public byte[] getBinary(int i) {
        return (byte[])this.getValue(i);
    }

    @Override
    public Object getValueByField(String field) {
        return this.getValueByPointer(this.fieldIndex.get(field));
    }

    @Override
    public String getStringByField(String field) {
        return (String)this.getValueByField(field);
    }

    @Override
    public Integer getIntegerByField(String field) {
        return (Integer)this.getValueByField(field);
    }

    @Override
    public Long getLongByField(String field) {
        return (Long)this.getValueByField(field);
    }

    @Override
    public Boolean getBooleanByField(String field) {
        return (Boolean)this.getValueByField(field);
    }

    @Override
    public Short getShortByField(String field) {
        return (Short)this.getValueByField(field);
    }

    @Override
    public Byte getByteByField(String field) {
        return (Byte)this.getValueByField(field);
    }

    @Override
    public Double getDoubleByField(String field) {
        return (Double)this.getValueByField(field);
    }

    @Override
    public Float getFloatByField(String field) {
        return (Float)this.getValueByField(field);
    }

    @Override
    public byte[] getBinaryByField(String field) {
        return (byte[])this.getValueByField(field);
    }

    private Object getValueByPointer(ValuePointer ptr) {
        return this.delegates.get(ptr.delegateIndex).get(ptr.index);
    }

    public static class FreshOutputFactory
    implements TridentTuple.Factory {
        Map<String, ValuePointer> fieldIndex = new HashMap<String, ValuePointer>();
        ValuePointer[] index;

        public FreshOutputFactory(Fields selfFields) {
            for (int i = 0; i < selfFields.size(); ++i) {
                String field = selfFields.get(i);
                this.fieldIndex.put(field, new ValuePointer(0, i, field));
            }
            this.index = ValuePointer.buildIndex(selfFields, this.fieldIndex);
        }

        public TridentTuple create(List<Object> selfVals) {
            return new TridentTupleView(Arrays.asList(selfVals), this.index, this.fieldIndex);
        }

        @Override
        public Map<String, ValuePointer> getFieldIndex() {
            return this.fieldIndex;
        }

        @Override
        public int numDelegates() {
            return 1;
        }

        @Override
        public List<String> getOutputFields() {
            return TridentTupleView.indexToFieldsList(this.index);
        }
    }

    public static class RootFactory
    implements TridentTuple.Factory {
        ValuePointer[] index;
        Map<String, ValuePointer> fieldIndex;

        public RootFactory(Fields inputFields) {
            this.index = new ValuePointer[inputFields.size()];
            int i = 0;
            for (String f : inputFields) {
                this.index[i] = new ValuePointer(0, i, f);
                ++i;
            }
            this.fieldIndex = ValuePointer.buildFieldIndex(this.index);
        }

        public TridentTuple create(Tuple parent) {
            return new TridentTupleView(Arrays.asList(parent.getValues()), this.index, this.fieldIndex);
        }

        @Override
        public Map<String, ValuePointer> getFieldIndex() {
            return this.fieldIndex;
        }

        @Override
        public int numDelegates() {
            return 1;
        }

        @Override
        public List<String> getOutputFields() {
            return TridentTupleView.indexToFieldsList(this.index);
        }
    }

    public static class OperationOutputFactory
    implements TridentTuple.Factory {
        Map<String, ValuePointer> fieldIndex;
        ValuePointer[] index;
        TridentTuple.Factory parent;

        public OperationOutputFactory(TridentTuple.Factory parent, Fields selfFields) {
            this.parent = parent;
            this.fieldIndex = new HashMap<String, ValuePointer>(parent.getFieldIndex());
            int myIndex = parent.numDelegates();
            for (int i = 0; i < selfFields.size(); ++i) {
                String field = selfFields.get(i);
                this.fieldIndex.put(field, new ValuePointer(myIndex, i, field));
            }
            ArrayList<String> myOrder = new ArrayList<String>(parent.getOutputFields());
            HashSet<String> parentFieldsSet = new HashSet<String>(myOrder);
            for (String f : selfFields) {
                if (parentFieldsSet.contains(f)) {
                    throw new IllegalArgumentException("Additive operations cannot add fields with same name as already exists. Tried adding " + String.valueOf(selfFields) + " to " + String.valueOf(parent.getOutputFields()));
                }
                myOrder.add(f);
            }
            this.index = ValuePointer.buildIndex(new Fields(myOrder), this.fieldIndex);
        }

        public TridentTuple create(TridentTupleView parent, List<Object> selfVals) {
            ArrayList<List<Object>> curr = new ArrayList<List<Object>>(parent.delegates);
            curr.add(selfVals);
            return new TridentTupleView(curr, this.index, this.fieldIndex);
        }

        @Override
        public Map<String, ValuePointer> getFieldIndex() {
            return this.fieldIndex;
        }

        @Override
        public int numDelegates() {
            return this.parent.numDelegates() + 1;
        }

        @Override
        public List<String> getOutputFields() {
            return TridentTupleView.indexToFieldsList(this.index);
        }
    }

    public static class ProjectionFactory
    implements TridentTuple.Factory {
        Map<String, ValuePointer> fieldIndex;
        ValuePointer[] index;
        TridentTuple.Factory parent;

        public ProjectionFactory(TridentTuple.Factory parent, Fields projectFields) {
            this.parent = parent;
            if (projectFields == null) {
                projectFields = new Fields(new String[0]);
            }
            Map<String, ValuePointer> parentFieldIndex = parent.getFieldIndex();
            this.fieldIndex = new HashMap<String, ValuePointer>();
            for (String f : projectFields) {
                this.fieldIndex.put(f, parentFieldIndex.get(f));
            }
            this.index = ValuePointer.buildIndex(projectFields, this.fieldIndex);
        }

        public TridentTuple create(TridentTuple parent) {
            if (this.index.length == 0) {
                return EMPTY_TUPLE;
            }
            return new TridentTupleView(((TridentTupleView)parent).delegates, this.index, this.fieldIndex);
        }

        @Override
        public Map<String, ValuePointer> getFieldIndex() {
            return this.fieldIndex;
        }

        @Override
        public int numDelegates() {
            return this.parent.numDelegates();
        }

        @Override
        public List<String> getOutputFields() {
            return TridentTupleView.indexToFieldsList(this.index);
        }
    }
}

