/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.windowing;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.storm.coordination.BatchOutputCollector;
import org.apache.storm.trident.operation.Aggregator;
import org.apache.storm.trident.spout.IBatchID;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.trident.tuple.TridentTupleView;
import org.apache.storm.trident.windowing.AbstractTridentWindowManager;
import org.apache.storm.trident.windowing.TridentBatchTuple;
import org.apache.storm.trident.windowing.WindowTridentProcessor;
import org.apache.storm.trident.windowing.WindowsStore;
import org.apache.storm.trident.windowing.config.WindowConfig;
import org.apache.storm.tuple.Fields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreBasedTridentWindowManager
extends AbstractTridentWindowManager<TridentBatchTuple> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreBasedTridentWindowManager.class);
    private static final String TUPLE_PREFIX = "tu|";
    private final String windowTupleTaskId;
    private final TridentTupleView.FreshOutputFactory freshOutputFactory;
    private final Fields inputFields;
    private Long maxCachedTuplesSize;
    private AtomicLong currentCachedTuplesSize = new AtomicLong();

    public StoreBasedTridentWindowManager(WindowConfig windowConfig, String windowTaskId, WindowsStore windowStore, Aggregator aggregator, BatchOutputCollector delegateCollector, Long maxTuplesCacheSize, Fields inputFields) {
        super(windowConfig, windowTaskId, windowStore, aggregator, delegateCollector);
        this.maxCachedTuplesSize = maxTuplesCacheSize;
        this.inputFields = inputFields;
        this.freshOutputFactory = new TridentTupleView.FreshOutputFactory(inputFields);
        this.windowTupleTaskId = TUPLE_PREFIX + windowTaskId;
    }

    @Override
    protected void initialize() {
        String windowTriggerInprocessId = WindowTridentProcessor.getWindowTriggerInprocessIdPrefix(this.windowTaskId);
        String windowTriggerTaskId = WindowTridentProcessor.getWindowTriggerTaskPrefix(this.windowTaskId);
        ArrayList<String> attemptedTriggerKeys = new ArrayList<String>();
        ArrayList<String> triggerKeys = new ArrayList<String>();
        Iterable<String> allEntriesIterable = this.windowStore.getAllKeys();
        for (String key : allEntriesIterable) {
            if (key.startsWith(this.windowTupleTaskId)) {
                int tupleIndexValue = this.lastPart(key);
                String batchId = this.secondLastPart(key);
                LOG.debug("Received tuple with batch [{}] and tuple index [{}]", (Object)batchId, (Object)tupleIndexValue);
                this.windowManager.add(new TridentBatchTuple(batchId, System.currentTimeMillis(), tupleIndexValue));
                continue;
            }
            if (key.startsWith(windowTriggerTaskId)) {
                triggerKeys.add(key);
                LOG.debug("Received trigger with key [{}]", (Object)key);
                continue;
            }
            if (!key.startsWith(windowTriggerInprocessId)) continue;
            attemptedTriggerKeys.add(key);
            LOG.debug("Received earlier unsuccessful trigger [{}] from windows store [{}]", (Object)key);
        }
        HashSet triggersToBeIgnored = new HashSet();
        Iterable<Object> attemptedTriggers = this.windowStore.get(attemptedTriggerKeys);
        for (Object attemptedTrigger : attemptedTriggers) {
            triggersToBeIgnored.addAll((List)attemptedTrigger);
        }
        Iterable<Object> triggerObjects = this.windowStore.get(triggerKeys);
        int i = 0;
        for (Object triggerObject : triggerObjects) {
            int id;
            if (triggersToBeIgnored.contains(id = this.lastPart((String)triggerKeys.get(i++)))) continue;
            LOG.info("Adding pending trigger value [{}]", triggerObject);
            this.pendingTriggers.add(new AbstractTridentWindowManager.TriggerResult(id, (List)triggerObject));
        }
    }

    private int lastPart(String key) {
        int lastSepIndex = key.lastIndexOf("|");
        if (lastSepIndex < 0) {
            throw new IllegalArgumentException("primaryKey does not have key separator '|'");
        }
        return Integer.parseInt(key.substring(lastSepIndex + 1));
    }

    private String secondLastPart(String key) {
        int lastSepIndex = key.lastIndexOf("|");
        if (lastSepIndex < 0) {
            throw new IllegalArgumentException("key " + key + " does not have key separator '|'");
        }
        String trimKey = key.substring(0, lastSepIndex);
        int secondLastSepIndex = trimKey.lastIndexOf("|");
        if (secondLastSepIndex < 0) {
            throw new IllegalArgumentException("key " + key + " does not have second key separator '|'");
        }
        return key.substring(secondLastSepIndex + 1, lastSepIndex);
    }

    @Override
    public void addTuplesBatch(Object batchId, List<TridentTuple> tuples) {
        TridentTuple tridentTuple;
        String key;
        int i;
        LOG.debug("Adding tuples to window-manager for batch: [{}]", batchId);
        ArrayList<WindowsStore.Entry> entries = new ArrayList<WindowsStore.Entry>();
        for (i = 0; i < tuples.size(); ++i) {
            key = this.keyOf(batchId);
            tridentTuple = tuples.get(i);
            entries.add(new WindowsStore.Entry(key + i, tridentTuple.select(this.inputFields)));
        }
        this.windowStore.putAll(entries);
        for (i = 0; i < tuples.size(); ++i) {
            key = this.keyOf(batchId);
            tridentTuple = tuples.get(i);
            this.addToWindowManager(i, key, tridentTuple);
        }
    }

    private void addToWindowManager(int tupleIndex, String effectiveBatchId, TridentTuple tridentTuple) {
        TridentTuple actualTuple = null;
        if (this.maxCachedTuplesSize == null || this.currentCachedTuplesSize.get() < this.maxCachedTuplesSize) {
            actualTuple = tridentTuple;
        }
        this.currentCachedTuplesSize.incrementAndGet();
        this.windowManager.add(new TridentBatchTuple(effectiveBatchId, System.currentTimeMillis(), tupleIndex, actualTuple));
    }

    public String getBatchTxnId(Object batchId) {
        if (!(batchId instanceof IBatchID)) {
            throw new IllegalArgumentException("argument should be an IBatchId instance");
        }
        return ((IBatchID)batchId).getId().toString();
    }

    public String keyOf(Object batchId) {
        return this.windowTupleTaskId + this.getBatchTxnId(batchId) + "|";
    }

    @Override
    public List<TridentTuple> getTridentTuples(List<TridentBatchTuple> tridentBatchTuples) {
        ArrayList<TridentTuple> resultTuples = new ArrayList<TridentTuple>();
        ArrayList<String> keys = new ArrayList<String>();
        for (TridentBatchTuple tridentBatchTuple : tridentBatchTuples) {
            TridentTuple tuple = this.collectTridentTupleOrKey(tridentBatchTuple, keys);
            if (tuple == null) continue;
            resultTuples.add(tuple);
        }
        if (keys.size() > 0) {
            Iterable<Object> storedTupleValues = this.windowStore.get(keys);
            for (Object storedTupleValue : storedTupleValues) {
                TridentTuple tridentTuple = this.freshOutputFactory.create((List)storedTupleValue);
                resultTuples.add(tridentTuple);
            }
        }
        return resultTuples;
    }

    public TridentTuple collectTridentTupleOrKey(TridentBatchTuple tridentBatchTuple, List<String> keys) {
        if (tridentBatchTuple.tridentTuple != null) {
            return tridentBatchTuple.tridentTuple;
        }
        keys.add(this.tupleKey(tridentBatchTuple));
        return null;
    }

    @Override
    public void onTuplesExpired(List<TridentBatchTuple> expiredTuples) {
        if (this.maxCachedTuplesSize != null) {
            this.currentCachedTuplesSize.addAndGet(-expiredTuples.size());
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (TridentBatchTuple expiredTuple : expiredTuples) {
            keys.add(this.tupleKey(expiredTuple));
        }
        this.windowStore.removeAll(keys);
    }

    private String tupleKey(TridentBatchTuple tridentBatchTuple) {
        return tridentBatchTuple.effectiveBatchId + tridentBatchTuple.tupleIndex;
    }
}

