/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.naming.ConfigurationException;
import org.apache.storm.shade.org.apache.commons.lang.StringUtils;
import org.apache.storm.shade.org.apache.curator.RetryPolicy;
import org.apache.storm.shade.org.apache.curator.framework.CuratorFramework;
import org.apache.storm.shade.org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.storm.shade.org.apache.curator.framework.api.ACLProvider;
import org.apache.storm.shade.org.apache.zookeeper.ClientCnxnSocketNetty;
import org.apache.storm.shade.org.apache.zookeeper.client.ZKClientConfig;
import org.apache.storm.shade.org.apache.zookeeper.common.ClientX509Util;
import org.apache.storm.shade.org.apache.zookeeper.data.ACL;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.StormBoundedExponentialBackoffRetry;
import org.apache.storm.utils.ZookeeperAuthInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuratorUtils {
    public static final Logger LOG = LoggerFactory.getLogger(CuratorUtils.class);
    public static final String CLIENT_CNXN = ClientCnxnSocketNetty.class.getName();

    public static CuratorFramework newCurator(Map<String, Object> conf, List<String> servers, Object port, String root, List<ACL> defaultAcl) {
        return CuratorUtils.newCurator(conf, servers, port, root, null, defaultAcl);
    }

    public static CuratorFramework newCurator(Map<String, Object> conf, List<String> servers, Object port, ZookeeperAuthInfo auth, List<ACL> defaultAcl) {
        return CuratorUtils.newCurator(conf, servers, port, "", auth, defaultAcl);
    }

    public static CuratorFramework newCurator(Map<String, Object> conf, List<String> servers, Object port, String root, ZookeeperAuthInfo auth, final List<ACL> defaultAcl) {
        ArrayList<CallSite> serverPorts = new ArrayList<CallSite>();
        for (String zkServer : servers) {
            serverPorts.add((CallSite)((Object)(zkServer + ":" + ObjectReader.getInt(port))));
        }
        String zkStr = StringUtils.join(serverPorts, (String)",") + root;
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder();
        CuratorUtils.setupBuilder(builder, zkStr, conf, auth);
        if (defaultAcl != null) {
            builder.aclProvider(new ACLProvider(){

                public List<ACL> getDefaultAcl() {
                    return defaultAcl;
                }

                public List<ACL> getAclForPath(String s) {
                    return null;
                }
            });
        }
        return builder.build();
    }

    protected static void setupBuilder(CuratorFrameworkFactory.Builder builder, String zkStr, Map<String, Object> conf, ZookeeperAuthInfo auth) {
        boolean sslEnabled;
        builder.connectString(zkStr);
        builder.connectionTimeoutMs(ObjectReader.getInt(conf.get("storm.zookeeper.connection.timeout")).intValue()).sessionTimeoutMs(ObjectReader.getInt(conf.get("storm.zookeeper.session.timeout")).intValue()).retryPolicy((RetryPolicy)new StormBoundedExponentialBackoffRetry(ObjectReader.getInt(conf.get("storm.zookeeper.retry.interval")), ObjectReader.getInt(conf.get("storm.zookeeper.retry.intervalceiling.millis")), ObjectReader.getInt(conf.get("storm.zookeeper.retry.times"))));
        if (auth != null && auth.scheme != null && auth.payload != null) {
            builder.authorization(auth.scheme, auth.payload);
        }
        if (sslEnabled = ObjectReader.getBoolean(conf.get("storm.zookeeper.ssl.enable"), false)) {
            SslConf sslConf = new SslConf(conf);
            ZKClientConfig zkClientConfig = new ZKClientConfig();
            try {
                CuratorUtils.setSslConfiguration(zkClientConfig, new ClientX509Util(), sslConf);
            }
            catch (ConfigurationException e) {
                throw new RuntimeException(e);
            }
            builder.zkClientConfig(zkClientConfig);
        }
    }

    private static void setSslConfiguration(ZKClientConfig zkClientConfig, ClientX509Util x509Util, SslConf sslConf) throws ConfigurationException {
        CuratorUtils.validateSslConfiguration(sslConf);
        LOG.info("Configuring the ZooKeeper client to use SSL/TLS encryption for connecting to the ZooKeeper server.");
        LOG.debug("Configuring the ZooKeeper client with {} location: {}.", (Object)sslConf.keystoreLocation, (Object)"storm.zookeeper.ssl.keystore.path");
        LOG.debug("Configuring the ZooKeeper client with {} location: {}.", (Object)sslConf.truststoreLocation, (Object)"storm.zookeeper.ssl.truststore.path");
        zkClientConfig.setProperty("zookeeper.client.secure", "true");
        zkClientConfig.setProperty("zookeeper.clientCnxnSocket", CLIENT_CNXN);
        zkClientConfig.setProperty(x509Util.getSslKeystoreLocationProperty(), sslConf.keystoreLocation);
        zkClientConfig.setProperty(x509Util.getSslKeystorePasswdProperty(), sslConf.keystorePassword);
        zkClientConfig.setProperty(x509Util.getSslTruststoreLocationProperty(), sslConf.truststoreLocation);
        zkClientConfig.setProperty(x509Util.getSslTruststorePasswdProperty(), sslConf.truststorePassword);
        zkClientConfig.setProperty(x509Util.getSslHostnameVerificationEnabledProperty(), sslConf.hostnameVerification.toString());
    }

    private static void validateSslConfiguration(SslConf sslConf) throws ConfigurationException {
        if (StringUtils.isEmpty((String)sslConf.getKeystoreLocation())) {
            throw new ConfigurationException("The keystore location parameter is empty for the ZooKeeper client connection.");
        }
        if (StringUtils.isEmpty((String)sslConf.getKeystorePassword())) {
            throw new ConfigurationException("The keystore password parameter is empty for the ZooKeeper client connection.");
        }
        if (StringUtils.isEmpty((String)sslConf.getTruststoreLocation())) {
            throw new ConfigurationException("The truststore location parameter is empty for the ZooKeeper client connection.");
        }
        if (StringUtils.isEmpty((String)sslConf.getTruststorePassword())) {
            throw new ConfigurationException("The truststore password parameter is empty for the ZooKeeper client connection.");
        }
    }

    public static SslConf getSslConf(Map<String, Object> conf) {
        return new SslConf(conf);
    }

    public static void testSetupBuilder(CuratorFrameworkFactory.Builder builder, String zkStr, Map<String, Object> conf, ZookeeperAuthInfo auth) {
        CuratorUtils.setupBuilder(builder, zkStr, conf, auth);
    }

    public static CuratorFramework newCuratorStarted(Map<String, Object> conf, List<String> servers, Object port, String root, ZookeeperAuthInfo auth, List<ACL> defaultAcl) {
        CuratorFramework ret = CuratorUtils.newCurator(conf, servers, port, root, auth, defaultAcl);
        LOG.info("Starting Utils Curator...");
        ret.start();
        return ret;
    }

    public static CuratorFramework newCuratorStarted(Map<String, Object> conf, List<String> servers, Object port, ZookeeperAuthInfo auth, List<ACL> defaultAcl) {
        CuratorFramework ret = CuratorUtils.newCurator(conf, servers, port, auth, defaultAcl);
        LOG.info("Starting Utils Curator (2)...");
        ret.start();
        return ret;
    }

    static final class SslConf {
        private final String keystoreLocation;
        private final String keystorePassword;
        private final String truststoreLocation;
        private final String truststorePassword;
        private final Boolean hostnameVerification;

        private SslConf(Map<String, Object> conf) {
            this.keystoreLocation = ObjectReader.getString(conf.get("storm.zookeeper.ssl.keystore.path"), "");
            this.keystorePassword = ObjectReader.getString(conf.get("storm.zookeeper.ssl.keystore.password"), "");
            this.truststoreLocation = ObjectReader.getString(conf.get("storm.zookeeper.ssl.truststore.path"), "");
            this.truststorePassword = ObjectReader.getString(conf.get("storm.zookeeper.ssl.truststore.password"), "");
            this.hostnameVerification = ObjectReader.getBoolean(conf.get("storm.zookeeper.ssl.hostnameVerification"), true);
        }

        public String getKeystoreLocation() {
            return this.keystoreLocation;
        }

        public String getKeystorePassword() {
            return this.keystorePassword;
        }

        public String getTruststoreLocation() {
            return this.truststoreLocation;
        }

        public String getTruststorePassword() {
            return this.truststorePassword;
        }

        public Boolean getHostnameVerification() {
            return this.hostnameVerification;
        }
    }
}

