/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.time.Duration;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class FileChangeWatcher {
    private static final Logger LOG = LoggerFactory.getLogger(FileChangeWatcher.class);
    private final WatcherThread watcherThread;
    private State state;
    private FileTime lastModifiedTime;
    private final Object lastModifiedTimeLock;
    private final Path filePath;
    private final Duration pollInterval;

    public FileChangeWatcher(Path filePath, String threadNameSuffix, Duration pollInterval, FileChangeWatcherCallback callback) throws IOException {
        this.filePath = filePath;
        this.pollInterval = pollInterval;
        this.state = State.NEW;
        this.lastModifiedTimeLock = new Object();
        this.lastModifiedTime = Files.readAttributes(filePath, BasicFileAttributes.class, new LinkOption[0]).lastModifiedTime();
        this.watcherThread = new WatcherThread(threadNameSuffix, callback);
        this.watcherThread.setDaemon(true);
    }

    private synchronized State getState() {
        return this.state;
    }

    synchronized void waitForState(State desiredState) throws InterruptedException {
        while (this.state != desiredState) {
            this.wait();
        }
    }

    private synchronized void setState(State newState) {
        this.state = newState;
        this.notifyAll();
    }

    private synchronized boolean compareAndSetState(State expected, State update) {
        if (this.state == expected) {
            this.setState(update);
            return true;
        }
        return false;
    }

    private synchronized boolean compareAndSetState(State[] expectedStates, State update) {
        for (State expected : expectedStates) {
            if (this.state != expected) continue;
            this.setState(update);
            return true;
        }
        return false;
    }

    public void start() {
        if (!this.compareAndSetState(State.NEW, State.STARTING)) {
            return;
        }
        this.watcherThread.start();
    }

    public void stop() {
        if (this.compareAndSetState(new State[]{State.RUNNING, State.STARTING}, State.STOPPING)) {
            this.watcherThread.interrupt();
        }
    }

    String getWatcherThreadName() {
        return this.watcherThread.getName();
    }

    private static void handleException(Thread thread, Throwable e) {
        LOG.warn("Exception occurred from thread {}", (Object)thread.getName(), (Object)e);
    }

    private class WatcherThread
    extends Thread {
        private static final String THREAD_NAME_PREFIX = "FileChangeWatcher-";
        final FileChangeWatcherCallback callback;

        WatcherThread(String threadNameSuffix, FileChangeWatcherCallback callback) {
            super(THREAD_NAME_PREFIX + threadNameSuffix);
            this.callback = callback;
            this.setUncaughtExceptionHandler((x$0, x$1) -> FileChangeWatcher.handleException(x$0, x$1));
        }

        @Override
        public void run() {
            try {
                LOG.debug("{} thread started", (Object)this.getName());
                if (!FileChangeWatcher.this.compareAndSetState(State.STARTING, State.RUNNING)) {
                    State state = FileChangeWatcher.this.getState();
                    if (state != State.STOPPING) {
                        throw new IllegalStateException("Unexpected state: " + (Object)((Object)state));
                    }
                    return;
                }
                this.runLoop();
            }
            catch (Exception e) {
                LOG.warn("Error in runLoop()", (Throwable)e);
                throw new RuntimeException(e);
            }
            finally {
                LOG.debug("{} thread finished", (Object)this.getName());
                FileChangeWatcher.this.setState(State.STOPPED);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runLoop() throws IOException {
            while (FileChangeWatcher.this.getState() == State.RUNNING) {
                BasicFileAttributes attributes = Files.readAttributes(FileChangeWatcher.this.filePath, BasicFileAttributes.class, new LinkOption[0]);
                boolean modified = false;
                Object object = FileChangeWatcher.this.lastModifiedTimeLock;
                synchronized (object) {
                    FileTime maybeNewLastModifiedTime = attributes.lastModifiedTime();
                    if (!FileChangeWatcher.this.lastModifiedTime.equals(maybeNewLastModifiedTime)) {
                        modified = true;
                        FileChangeWatcher.this.lastModifiedTime = maybeNewLastModifiedTime;
                    }
                }
                if (modified) {
                    try {
                        this.callback.callback(FileChangeWatcher.this.filePath);
                    }
                    catch (Throwable e) {
                        LOG.error("Error from callback", e);
                    }
                }
                try {
                    Thread.sleep(FileChangeWatcher.this.pollInterval.toMillis());
                }
                catch (InterruptedException e) {
                    LOG.debug("Interrupted", (Throwable)e);
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }

    static enum State {
        NEW,
        STARTING,
        RUNNING,
        STOPPING,
        STOPPED;

    }

    public static interface FileChangeWatcherCallback {
        public void callback(Path var1);
    }
}

