/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.nimbus;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.storm.generated.Assignment;
import org.apache.storm.generated.WorkerResources;
import org.apache.storm.scheduler.SchedulerAssignment;
import org.apache.storm.scheduler.TopologyDetails;
import org.apache.storm.scheduler.WorkerSlot;
import org.apache.storm.scheduler.resource.normalization.NormalizedResourceRequest;

public final class TopologyResources {
    private final double requestedMemOnHeap;
    private final double requestedMemOffHeap;
    private final double requestedSharedMemOnHeap;
    private final double requestedSharedMemOffHeap;
    private final double requestedNonSharedMemOnHeap;
    private final double requestedNonSharedMemOffHeap;
    private final double requestedCpu;
    private Map<String, Double> requestedGenericResources;
    private double assignedMemOnHeap;
    private double assignedMemOffHeap;
    private double assignedSharedMemOnHeap;
    private double assignedSharedMemOffHeap;
    private double assignedNonSharedMemOnHeap;
    private double assignedNonSharedMemOffHeap;
    private double assignedCpu;
    private Map<String, Double> assignedGenericResources;

    private TopologyResources(TopologyDetails td, Collection<WorkerResources> workers, Map<String, Double> nodeIdToSharedOffHeapNode) {
        this.requestedMemOnHeap = td.getTotalRequestedMemOnHeap();
        this.requestedMemOffHeap = td.getTotalRequestedMemOffHeap();
        this.requestedSharedMemOnHeap = td.getRequestedSharedOnHeap();
        this.requestedSharedMemOffHeap = td.getRequestedSharedOffHeap();
        this.requestedNonSharedMemOnHeap = td.getRequestedNonSharedOnHeap();
        this.requestedNonSharedMemOffHeap = td.getRequestedNonSharedOffHeap();
        this.requestedCpu = td.getTotalRequestedCpu();
        this.requestedGenericResources = td.getTotalRequestedGenericResources();
        this.assignedMemOnHeap = 0.0;
        this.assignedMemOffHeap = 0.0;
        this.assignedSharedMemOnHeap = 0.0;
        this.assignedSharedMemOffHeap = 0.0;
        this.assignedNonSharedMemOnHeap = 0.0;
        this.assignedNonSharedMemOffHeap = 0.0;
        this.assignedCpu = 0.0;
        this.assignedGenericResources = new HashMap<String, Double>();
        if (workers != null) {
            for (WorkerResources resources : workers) {
                this.assignedMemOnHeap += resources.get_mem_on_heap();
                this.assignedMemOffHeap += resources.get_mem_off_heap();
                this.assignedCpu += resources.get_cpu();
                this.assignedNonSharedMemOnHeap += resources.get_mem_on_heap();
                this.assignedNonSharedMemOffHeap += resources.get_mem_off_heap();
                if (resources.is_set_mem_on_heap()) {
                    this.assignedNonSharedMemOnHeap -= resources.get_shared_mem_on_heap();
                    this.assignedSharedMemOnHeap += resources.get_shared_mem_on_heap();
                }
                if (!resources.is_set_shared_mem_off_heap()) continue;
                this.assignedSharedMemOffHeap += resources.get_shared_mem_off_heap();
                this.assignedNonSharedMemOffHeap -= resources.get_shared_mem_off_heap();
            }
            this.assignedGenericResources = this.computeAssignedGenericResources(workers);
        }
        if (nodeIdToSharedOffHeapNode != null) {
            double sharedOff = nodeIdToSharedOffHeapNode.values().stream().reduce(0.0, (sum, val) -> sum + val);
            this.assignedSharedMemOffHeap += sharedOff;
            this.assignedMemOffHeap += sharedOff;
        }
    }

    private Map<String, Double> computeAssignedGenericResources(Collection<WorkerResources> workers) {
        Map<String, Double> genericResources = new HashMap<String, Double>();
        for (WorkerResources worker : workers) {
            genericResources = NormalizedResourceRequest.addResourceMap(genericResources, worker.get_resources());
        }
        NormalizedResourceRequest.removeNonGenericResources(genericResources);
        return genericResources;
    }

    public TopologyResources(TopologyDetails td, SchedulerAssignment assignment) {
        this(td, TopologyResources.getWorkerResources(assignment), TopologyResources.getNodeIdToSharedOffHeapNode(assignment));
    }

    public TopologyResources(TopologyDetails td, Assignment assignment) {
        this(td, TopologyResources.getWorkerResources(assignment), TopologyResources.getNodeIdToSharedOffHeapNode(assignment));
    }

    public TopologyResources() {
        this(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, new HashMap<String, Double>(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, new HashMap<String, Double>());
    }

    protected TopologyResources(double requestedMemOnHeap, double requestedMemOffHeap, double requestedSharedMemOnHeap, double requestedSharedMemOffHeap, double requestedNonSharedMemOnHeap, double requestedNonSharedMemOffHeap, double requestedCpu, Map<String, Double> requestedGenericResources, double assignedMemOnHeap, double assignedMemOffHeap, double assignedSharedMemOnHeap, double assignedSharedMemOffHeap, double assignedNonSharedMemOnHeap, double assignedNonSharedMemOffHeap, double assignedCpu, Map<String, Double> assignedGenericResources) {
        this.requestedMemOnHeap = requestedMemOnHeap;
        this.requestedMemOffHeap = requestedMemOffHeap;
        this.requestedSharedMemOnHeap = requestedSharedMemOnHeap;
        this.requestedSharedMemOffHeap = requestedSharedMemOffHeap;
        this.requestedNonSharedMemOnHeap = requestedNonSharedMemOnHeap;
        this.requestedNonSharedMemOffHeap = requestedNonSharedMemOffHeap;
        this.requestedCpu = requestedCpu;
        this.requestedGenericResources = requestedGenericResources;
        this.assignedMemOnHeap = assignedMemOnHeap;
        this.assignedMemOffHeap = assignedMemOffHeap;
        this.assignedSharedMemOnHeap = assignedSharedMemOnHeap;
        this.assignedSharedMemOffHeap = assignedSharedMemOffHeap;
        this.assignedNonSharedMemOnHeap = assignedNonSharedMemOnHeap;
        this.assignedNonSharedMemOffHeap = assignedNonSharedMemOffHeap;
        this.assignedCpu = assignedCpu;
        this.assignedGenericResources = assignedGenericResources;
    }

    private static Collection<WorkerResources> getWorkerResources(SchedulerAssignment assignment) {
        Map<WorkerSlot, WorkerResources> allResources;
        Collection<WorkerResources> ret = null;
        if (assignment != null && (allResources = assignment.getScheduledResources()) != null) {
            ret = allResources.values();
        }
        return ret;
    }

    private static Collection<WorkerResources> getWorkerResources(Assignment assignment) {
        Map allResources;
        Collection ret = null;
        if (assignment != null && (allResources = assignment.get_worker_resources()) != null) {
            ret = allResources.values();
        }
        return ret;
    }

    private static Map<String, Double> getNodeIdToSharedOffHeapNode(SchedulerAssignment assignment) {
        Map<String, Double> ret = null;
        if (assignment != null) {
            ret = assignment.getNodeIdToTotalSharedOffHeapNodeMemory();
        }
        return ret;
    }

    private static Map<String, Double> getNodeIdToSharedOffHeapNode(Assignment assignment) {
        Map ret = null;
        if (assignment != null) {
            ret = assignment.get_total_shared_off_heap();
        }
        return ret;
    }

    public double getRequestedMemOnHeap() {
        return this.requestedMemOnHeap;
    }

    public double getRequestedMemOffHeap() {
        return this.requestedMemOffHeap;
    }

    public double getRequestedCpu() {
        return this.requestedCpu;
    }

    public double getAssignedMemOnHeap() {
        return this.assignedMemOnHeap;
    }

    public void setAssignedMemOnHeap(double assignedMemOnHeap) {
        this.assignedMemOnHeap = assignedMemOnHeap;
    }

    public double getAssignedMemOffHeap() {
        return this.assignedMemOffHeap;
    }

    public void setAssignedMemOffHeap(double assignedMemOffHeap) {
        this.assignedMemOffHeap = assignedMemOffHeap;
    }

    public double getAssignedCpu() {
        return this.assignedCpu;
    }

    public void setAssignedCpu(double assignedCpu) {
        this.assignedCpu = assignedCpu;
    }

    public double getAssignedSharedMemOnHeap() {
        return this.assignedSharedMemOnHeap;
    }

    public void setAssignedSharedMemOnHeap(double assignedSharedMemOnHeap) {
        this.assignedSharedMemOnHeap = assignedSharedMemOnHeap;
    }

    public double getRequestedSharedMemOnHeap() {
        return this.requestedSharedMemOnHeap;
    }

    public double getRequestedSharedMemOffHeap() {
        return this.requestedSharedMemOffHeap;
    }

    public double getRequestedNonSharedMemOnHeap() {
        return this.requestedNonSharedMemOnHeap;
    }

    public double getRequestedNonSharedMemOffHeap() {
        return this.requestedNonSharedMemOffHeap;
    }

    public double getAssignedSharedMemOffHeap() {
        return this.assignedSharedMemOffHeap;
    }

    public void setAssignedSharedMemOffHeap(double assignedSharedMemOffHeap) {
        this.assignedSharedMemOffHeap = assignedSharedMemOffHeap;
    }

    public double getAssignedNonSharedMemOnHeap() {
        return this.assignedNonSharedMemOnHeap;
    }

    public void setAssignedNonSharedMemOnHeap(double assignedNonSharedMemOnHeap) {
        this.assignedNonSharedMemOnHeap = assignedNonSharedMemOnHeap;
    }

    public double getAssignedNonSharedMemOffHeap() {
        return this.assignedNonSharedMemOffHeap;
    }

    public void setAssignedNonSharedMemOffHeap(double assignedNonSharedMemOffHeap) {
        this.assignedNonSharedMemOffHeap = assignedNonSharedMemOffHeap;
    }

    public Map<String, Double> getAssignedGenericResources() {
        return new HashMap<String, Double>(this.assignedGenericResources);
    }

    public Map<String, Double> getRequestedGenericResources() {
        return new HashMap<String, Double>(this.requestedGenericResources);
    }

    public TopologyResources add(TopologyResources other) {
        return new TopologyResources(this.requestedMemOnHeap + other.requestedMemOnHeap, this.requestedMemOffHeap + other.requestedMemOffHeap, this.requestedSharedMemOnHeap + other.requestedSharedMemOnHeap, this.requestedSharedMemOffHeap + other.requestedSharedMemOffHeap, this.requestedNonSharedMemOnHeap + other.requestedNonSharedMemOnHeap, this.requestedNonSharedMemOffHeap + other.requestedNonSharedMemOffHeap, this.requestedCpu + other.requestedCpu, NormalizedResourceRequest.addResourceMap(this.requestedGenericResources, other.requestedGenericResources), this.assignedMemOnHeap + other.assignedMemOnHeap, this.assignedMemOffHeap + other.assignedMemOffHeap, this.assignedSharedMemOnHeap + other.assignedSharedMemOnHeap, this.assignedSharedMemOffHeap + other.assignedSharedMemOffHeap, this.assignedNonSharedMemOnHeap + other.assignedNonSharedMemOnHeap, this.assignedNonSharedMemOffHeap + other.assignedNonSharedMemOffHeap, this.assignedCpu + other.assignedCpu, NormalizedResourceRequest.addResourceMap(this.assignedGenericResources, other.assignedGenericResources));
    }
}

